/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class JarClassLoader
extends URLClassLoader {
    private File file;

    public JarClassLoader(File file, ClassLoader classLoader) throws IOException {
        super(JarClassLoader.getClassPath(file), classLoader);
        this.file = file;
    }

    public String getMainClass() throws IOException {
        return JarClassLoader.getAttribute(this.file, Attributes.Name.MAIN_CLASS);
    }

    private static URL[] getClassPath(File file) throws IOException {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        JarClassLoader.addToPath(linkedHashSet, file);
        return linkedHashSet.toArray(new URL[linkedHashSet.size()]);
    }

    private static void addToPath(Set set, File file) throws IOException {
        if (!(file = file.getCanonicalFile()).exists()) {
            return;
        }
        URL uRL = file.toURL();
        if (set.contains(uRL)) {
            return;
        }
        set.add(uRL);
        String string = JarClassLoader.getAttribute(file, Attributes.Name.CLASS_PATH);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                JarClassLoader.addToPath(set, new File(file.getParent(), stringTokenizer.nextToken()));
            }
        }
    }

    private static String getAttribute(File file, Attributes.Name name) {
        Attributes attributes = JarClassLoader.getAttributes(file);
        return attributes == null ? null : attributes.getValue(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getAttributes(File file) {
        Attributes attributes;
        if (!file.isFile()) {
            return null;
        }
        JarFile jarFile = new JarFile(file);
        try {
            attributes = jarFile.getManifest().getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        jarFile.close();
        return attributes;
    }
}

