/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.retrotranslator.transformer.ClassReaderFactory;
import net.sf.retrotranslator.transformer.ClassTransformer;
import net.sf.retrotranslator.transformer.ClassVerifier;
import net.sf.retrotranslator.transformer.FolderScanner;
import net.sf.retrotranslator.transformer.MessageLogger;

public class Retrotranslator
implements MessageLogger {
    private File srcdir;
    private File destdir;
    private String classpath;
    private boolean verify;
    private boolean stripsign;
    private boolean verbose;
    static /* synthetic */ Class class$net$sf$retrotranslator$transformer$Retrotranslator;

    public Retrotranslator(File file, File file2, String string, boolean bl, boolean bl2, boolean bl3) {
        this.srcdir = file;
        this.destdir = file2;
        this.classpath = string;
        this.verify = bl;
        this.stripsign = bl2;
        this.verbose = bl3;
    }

    public Retrotranslator(String[] stringArray) throws IllegalArgumentException {
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if ((string = stringArray[n++]).equals("-srcdir") && n < stringArray.length) {
                this.srcdir = Retrotranslator.checkDir(stringArray[n++]);
                continue;
            }
            if (string.equals("-destdir") && n < stringArray.length) {
                this.destdir = Retrotranslator.checkDir(stringArray[n++]);
                continue;
            }
            if (string.equals("-stripsign")) {
                this.stripsign = true;
                continue;
            }
            if (string.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (string.equals("-verify")) {
                this.verify = true;
                continue;
            }
            if (string.equals("-classpath") && n < stringArray.length) {
                this.classpath = stringArray[n++];
                continue;
            }
            throw new IllegalArgumentException("Unknown option: " + string);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Retrotranslator.printUsage();
            return;
        }
        try {
            Retrotranslator retrotranslator = new Retrotranslator(stringArray);
            if (!retrotranslator.run()) {
                System.exit(2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
            Retrotranslator.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        String string;
        Class<?> clazz = class$net$sf$retrotranslator$transformer$Retrotranslator;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$transformer$Retrotranslator = new Retrotranslator[0].getClass().getComponentType();
        }
        String string2 = (string = clazz.getPackage().getImplementationVersion()) == null ? "" : "-" + string;
        System.out.println("Usage: java -jar retrotranslator-transformer" + string2 + ".jar" + " -srcdir <path> [-destdir <path>] [-verbose] [-verify] [-classpath <classpath>]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        if (this.srcdir == null) {
            throw new IllegalArgumentException("Source directory is not set.");
        }
        if (this.destdir == null) {
            this.destdir = this.srcdir;
        }
        List list = new FolderScanner(this.srcdir).getFileNames();
        new ClassTransformer(this.stripsign).transform(this.srcdir, this.destdir, list, this);
        if (!this.verify) {
            return true;
        }
        ClassReaderFactory classReaderFactory = new ClassReaderFactory(this.classpath == null);
        try {
            if (this.classpath != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.classpath, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    classReaderFactory.appendPath(new File(stringTokenizer.nextToken()));
                }
            }
            classReaderFactory.appendPath(this.destdir);
            boolean bl = new ClassVerifier(classReaderFactory).verify(this.destdir, list, this);
            return bl;
        }
        finally {
            classReaderFactory.close();
        }
    }

    public void verbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    public void info(String string) {
        System.out.println(string);
    }

    public void warning(String string) {
        System.out.println(string);
    }

    private static File checkDir(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException(string + " not found.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(string + " is not a directory.");
        }
        return file;
    }
}

