#!/bin/zsh

#
# (c) Copyright 1999-2006 PaperCut Software International Pty Ltd
#
# A simple shell script to set up Java and launch the client software
# on a Mac system.  
#

#
# Find Java (look for the Java 5.0 as this is our preference)
#
javacmd="java"
jpath=/System/Library/Frameworks/JavaVM.framework/Versions/1.5/Commands/java

if [ -f "${jpath}" ]; then
	javacmd="${jpath}"
fi

#
# Make sure our current working dir is set to the location of this script
#
if [ -d /Applications/PCClient.app ]; then
	cd /Applications/PCClient.app/Contents/Resources
else
	cd "${0:h}"
fi

#
# Construct the classpath
#
classpath=`ls Java/*.jar | while read line
do
	printf "${line}:"
done`

#
# Run the program
#
${javacmd} -classpath "${classpath}" -Xdock:name="PaperCut NG" \
    -Dcom.apple.macos.useScreenMenuBar=true \
	-Dclient.home=. net.sf.retrotranslator.transformer.JITRetrotranslator \
	biz.papercut.pcng.client.uit.UserClient $* \
	>/dev/null 2>&1 &
exit
