/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthHandler;
import biz.papercut.pcng.client.uit.ClientAccountCache;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.ClientPrintJobHandler;
import biz.papercut.pcng.client.uit.DialogRequestHandler;
import biz.papercut.pcng.client.uit.IdentDialog;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.StressTester;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.common.SharedSecret;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.StringDataUtils;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.SingleInstanceLock;
import biz.papercut.pcng.util.swing.SwingUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

public final class UserClient {
    private static final Log logger = LogFactory.getLog(UserClient.class);
    private static final String PROP_CLIENT_USE_PROXY = "client.useProxy";
    private static final String ENV_CLIENT_ARGS = "PC_CLIENT_ARGS";
    private static SingleInstanceLock _lock;

    private UserClient() {
    }

    public static void main(String[] args) throws Exception {
        String envArgs = System.getenv(ENV_CLIENT_ARGS);
        if (StringUtils.isNotBlank((String)envArgs)) {
            args = UserClient.translateCommandline(envArgs);
        }
        if (args.length > 0 && args[0].equals("--stress-test")) {
            StressTester.main(args);
            return;
        }
        try {
            UserClientConfig conf;
            SwingUtils.setupSystemLookAndFeel();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    logger.error((Object)("Exception in thread \"" + t.getName() + "\". " + e.getMessage()), e);
                }
            });
            String s = System.getProperties().getProperty(PROP_CLIENT_USE_PROXY);
            if (!StringUtils.equalsIgnoreCase((String)"true", (String)s)) {
                System.getProperties().put("http.proxySet", "false");
                System.getProperties().put("http.proxyHost", "");
                System.getProperties().put("http.proxyPort", "");
                System.getProperties().put("https.proxySet", "false");
                System.getProperties().put("https.proxyHost", "");
                System.getProperties().put("https.proxyPort", "");
                System.getProperties().put("socksProxySet", "false");
                System.getProperties().put("socksProxyHost", "");
                System.getProperties().put("socksProxyPort", "");
            }
            if ((conf = UserClient.processConfigAndArgs(args)).isUseStandardWinLAF()) {
                logger.debug((Object)"Reverting to standard L&F");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Unable to use system LAF: " + e.getMessage()));
                        }
                    }
                });
            }
            if (conf.isDoPreAuthentication()) {
                UserClient.performPreAuthentication(conf);
            }
            if (conf.isClearAuthentication()) {
                UserClient.clearAuthenticationAndExit(conf);
            }
            logger.debug((Object)"Checking instance lock");
            _lock = new SingleInstanceLock("uc-" + conf.getServerIdHash(), conf.getLockDirectory());
            if (!conf.isMultipleInstancesAllowed() && !_lock.isFirstInstance()) {
                UserClient.exitWithError(UserClient.format("single-instance", new String[0]), conf.isSilent());
                return;
            }
            final UserClientFrame uit = new UserClientFrame();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    uit.preConnectionInit(conf);
                }
            });
            ServerConnection activeConn = null;
            try {
                logger.debug((Object)"Creating server connection");
                activeConn = new ServerConnection(conf.getServerName(), conf.getServerIP(), conf.getServerPort(), conf.getTimeoutSecs(), conf.isSilent());
            }
            catch (ServerConnection.ServerConnectionException sce) {
                uit.setVisible(false);
                uit.dispose();
                UserClient.exitWithError(UserClient.format("unable-to-connect", sce.getMessage()), conf.isSilent());
                return;
            }
            final ServerConnection connection = activeConn;
            UserClient.loadServerConfig(conf, uit, connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Config: " + conf));
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    uit.completeInitialisation(connection, conf);
                }
            });
            if (!conf.isUsePreAuthentication()) {
                connection.clearAuthentication();
            } else {
                logger.debug((Object)"Starting using pre-authentication");
            }
            ClientPrintJobHandler printJobHandler = new ClientPrintJobHandler(uit, connection, conf);
            DialogRequestHandler dialogRequestHandler = new DialogRequestHandler(uit, connection, conf);
            final AuthHandler authHandler = new AuthHandler(uit, connection, conf);
            ClientController controller = new ClientController(connection, conf);
            controller.addMessageListener(uit);
            controller.addBalanceListener(uit);
            controller.addPrintJobListener(printJobHandler);
            controller.addDialogRequestListener(dialogRequestHandler);
            controller.addAuthenticationRequestListener(authHandler);
            if (conf.getServerUserConfig().isUnauthenticatedUser() && conf.getServerGlobalConfig().isAuthPopupOnStartupIfUnauthenticated()) {
                Thread.sleep(1000L);
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        authHandler.doAuthRequest();
                    }
                });
            }
            controller.start();
        }
        catch (Throwable e) {
            logger.error((Object)("Error starting client: " + e.getMessage()), e);
            UserClient.exitWithError(UserClient.format("unexpected-error", e.getMessage()), false);
        }
    }

    private static void clearAuthenticationAndExit(UserClientConfig conf) {
        ServerConnection serverConnection = null;
        try {
            logger.debug((Object)"Creating server connection to clear authentication");
            serverConnection = new ServerConnection(conf.getServerName(), conf.getServerIP(), conf.getServerPort(), conf.getTimeoutSecs(), false);
            serverConnection.setUserName(conf.getUserName());
            serverConnection.getGlobalConfig();
        }
        catch (ServerConnection.ServerConnectionException sce) {
            logger.error((Object)"Unable to connect to server to clear the authentication", (Throwable)((Object)sce));
            System.exit(1);
        }
        if (serverConnection.clearAuthentication()) {
            System.exit(0);
        } else {
            logger.error((Object)"Unable to clear authentication");
            System.exit(1);
        }
    }

    private static void performPreAuthentication(UserClientConfig conf) {
        ClientAuthResponse response;
        logger.debug((Object)"Performing Pre-Authentication");
        if (StringUtils.isBlank((String)conf.getUserName())) {
            UserClient.exitWithError("--user required for pre-authentication", false);
        }
        if (StringUtils.isBlank((String)conf.getSharedSecretFile())) {
            UserClient.exitWithError("--shared-secret-file required for pre-authentication", false);
        }
        int ttl = -1;
        if (conf.getAuthTTLDefault() != null) {
            ttl = conf.getAuthTTLDefault();
        }
        ServerConnection serverConnection = null;
        try {
            logger.debug((Object)"Creating server connection");
            serverConnection = new ServerConnection(conf.getServerName(), conf.getServerIP(), conf.getServerPort(), conf.getTimeoutSecs(), false);
            serverConnection.setUserName(conf.getUserName());
            serverConnection.getGlobalConfig();
        }
        catch (ServerConnection.ServerConnectionException sce) {
            logger.error((Object)"Unable to connect to server for pre-authenticate", (Throwable)((Object)sce));
            System.exit(1);
        }
        String sharedSecret = null;
        try {
            logger.debug((Object)("Loading shared secret from: " + conf.getSharedSecretFile()));
            File f = new File(conf.getSharedSecretFile());
            if (f.exists()) {
                SharedSecret secret = new SharedSecret(f);
                sharedSecret = secret.getSecret();
            } else {
                logger.error((Object)("Could not find shared secret: " + f.getPath()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to load server's shared secret file", (Throwable)e);
        }
        if (StringUtils.isBlank(sharedSecret)) {
            logger.error((Object)"Invalid shared secret");
            System.exit(1);
        }
        if (!(response = serverConnection.authenticateUserWithSharedSecret(conf.getUserName(), sharedSecret, ttl)).isSuccess()) {
            logger.error((Object)("Pre-authentication failed: " + response.getErrorMessage()));
            System.exit(1);
        }
        logger.debug((Object)("Pre-authentication is successful for user: " + conf.getUserName()));
        System.exit(0);
    }

    private static void loadServerConfig(UserClientConfig conf, UserClientFrame uit, ServerConnection connection) throws Exception {
        connection.setUserName(conf.getUserName());
        conf.setServerGlobalConfig(connection.getGlobalConfig());
        boolean userExists = connection.userExists(conf.getUserName());
        boolean hasShownIdentDialog = false;
        if (conf.isAlwaysRequestIdentity()) {
            logger.debug((Object)"Displaying identity dialog - configured to always display");
            UserClient.displayIdentDialog(conf, uit, connection);
            hasShownIdentDialog = true;
            connection.setUserName(conf.getUserName());
            userExists = connection.userExists(conf.getUserName());
        }
        if (!(hasShownIdentDialog || userExists || conf.isNeverRequestIdentity())) {
            logger.debug((Object)"Displaying identity dialog - user does not exist");
            UserClient.displayIdentDialog(conf, uit, connection);
            connection.setUserName(conf.getUserName());
            userExists = connection.userExists(conf.getUserName());
        }
        if (!userExists) {
            if (!conf.isSilent() && !conf.isSuccessfullyIdentified()) {
                String errorMessage = UserClient.format("user-not-found", conf.getUserName());
                uit.setVisible(false);
                uit.dispose();
                UserClient.exitWithError(errorMessage, conf.isSilent());
            }
            uit.setTaskTrayToolTip(UserClient.format("user-not-found-task-tray", conf.getUserName()));
            int maxRetryDelay = 30;
            int retryDelayIncrement = 3;
            int retryDelay = 2;
            do {
                try {
                    logger.debug((Object)("Retry checkin if user exists in: " + retryDelay + " secs."));
                    Thread.sleep(retryDelay * 1000);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((retryDelay += 3) <= 30) continue;
                retryDelay = 30;
            } while (!(userExists = connection.userExists(conf.getUserName())));
        }
        conf.setServerUserConfig(connection.getUserConfig());
        if (conf.isHideBalance()) {
            logger.debug((Object)"Hide balance specified on command-line or config file.");
            conf.getServerUserConfig().setShowBalance(false);
        }
        UserClient.setupWebPageURLs(conf, connection.getConnectionName());
        ClientAccountCache.initialise(connection, conf);
    }

    private static void displayIdentDialog(final UserClientConfig conf, final UserClientFrame uit, final ServerConnection connection) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                IdentDialog d = new IdentDialog(uit, conf, connection);
                d.setVisible(true);
                d.dispose();
                d = null;
            }
        });
    }

    private static void setupWebPageURLs(UserClientConfig conf, String connectionHostName) throws MalformedURLException {
        ClientGlobalConfigFromServer serverConf = conf.getServerGlobalConfig();
        boolean ssl = serverConf.isUseSslInBrowser() && serverConf.getSslPort() > 0;
        String protocol = ssl ? "https" : "http";
        int port = ssl ? serverConf.getSslPort() : conf.getServerPort();
        URL userPageURL = new URL(protocol, connectionHostName, port, serverConf.getUserPagePath());
        URL registerPageURL = new URL(protocol, connectionHostName, port, serverConf.getRegisterPagePath());
        conf.setUserPageURL(userPageURL.toString());
        conf.setRegisterPageURL(registerPageURL.toString());
    }

    private static UserClientConfig processConfigAndArgs(String[] args) {
        CommandLine cmdLine;
        UserClientConfig conf = new UserClientConfig();
        UserClient.initLogging(false);
        Properties prop = null;
        try {
            prop = ClientConfigFile.loadConfig();
        }
        catch (Exception e) {
            UserClient.exitWithError(UserClient.format("cant-load-config", e.getMessage()), conf.isSilent());
        }
        if (StringUtils.isNotEmpty((String)prop.getProperty("user"))) {
            conf.setUserName(prop.getProperty("user"));
            conf.setDisplayUserName(conf.getUserName());
        }
        if ("Y".equals(prop.getProperty("silent"))) {
            conf.setSilent(true);
        }
        if ("Y".equals(prop.getProperty("neverrequestidentity"))) {
            conf.setNeverRequestIdentity(true);
        }
        if ("Y".equals(prop.getProperty("standard-win-laf"))) {
            conf.setUseStandardWinLAF(true);
        }
        if ("Y".equals(prop.getProperty("disable-gui-effects"))) {
            conf.setDisableGUIEffects(true);
        }
        if ("Y".equals(prop.getProperty("minimized"))) {
            conf.setStartMinimised(true);
        }
        if ("Y".equals(prop.getProperty("noquit"))) {
            conf.setDisallowExit(true);
        }
        if ("Y".equals(prop.getProperty("disabletasktrayicon"))) {
            conf.setDisableTaskTray(true);
        }
        if ("Y".equals(prop.getProperty("disable-balloon-tips"))) {
            conf.setDisableTaskTrayBalloonTips(true);
        }
        if ("Y".equals(prop.getProperty("hide-balance"))) {
            conf.setHideBalance(true);
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("windowposition"))) {
            conf.setWindowPosition(prop.getProperty("windowposition"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("windowtitle"))) {
            conf.setWindowTitle(prop.getProperty("windowtitle"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("background-color"))) {
            conf.setBackgroundColor(prop.getProperty("background-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("link-color"))) {
            conf.setLinkColor(prop.getProperty("link-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("link-hover-color"))) {
            conf.setLinkHoverColor(prop.getProperty("link-hover-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("text-color"))) {
            conf.setTextColor(prop.getProperty("text-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("lockdir"))) {
            conf.setLockDirectory(prop.getProperty("lockdir"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("accounts-file"))) {
            conf.setClientAccountsFile(prop.getProperty("accounts-file"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("default-selection"))) {
            conf.setDefaultSelectedOption(ChargeToAccountType.fromClientConfigValue((String)prop.getProperty("default-selection")));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("default-account"))) {
            conf.setDefaultSelectedAccount(prop.getProperty("default-account"));
        }
        if (prop.getProperty("default-account-pin") != null) {
            conf.setDefaultSelectedAccountPin(prop.getProperty("default-account-pin"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("auth-ttl-values"))) {
            conf.setAuthTTLValues(prop.getProperty("auth-ttl-values"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("auth-ttl-default"))) {
            try {
                conf.setAuthTTLDefault(Integer.valueOf(prop.getProperty("auth-ttl-default")));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((cmdLine = UserClient.parseCommandLine(args)).hasOption("s")) {
            conf.setSilent(true);
        }
        if (cmdLine.hasOption("b")) {
            conf.setDebugEnabled(true);
        }
        if (cmdLine.hasOption("B")) {
            conf.setHideBalance(true);
        }
        if (cmdLine.hasOption("a")) {
            conf.setAlwaysRequestIdentity(true);
        }
        if (cmdLine.hasOption("A")) {
            conf.setClientAccountsFile(cmdLine.getOptionValue("A"));
        }
        if (cmdLine.hasOption("n")) {
            conf.setNeverRequestIdentity(true);
        }
        if (cmdLine.hasOption("m")) {
            conf.setStartMinimised(true);
        }
        if (cmdLine.hasOption("l")) {
            conf.setMultipleInstancesAllowed(true);
        }
        if (cmdLine.hasOption("d")) {
            conf.setLockDirectory(cmdLine.getOptionValue("d"));
        }
        if (cmdLine.hasOption("w")) {
            conf.setUseStandardWinLAF(true);
        }
        if (cmdLine.hasOption("p")) {
            conf.setWindowPosition(cmdLine.getOptionValue("p"));
        }
        if (cmdLine.hasOption("t")) {
            conf.setWindowTitle(cmdLine.getOptionValue("t"));
        }
        if (cmdLine.hasOption("k")) {
            conf.setBackgroundColor(cmdLine.getOptionValue("k"));
        }
        if (cmdLine.hasOption("i")) {
            conf.setLinkColor(cmdLine.getOptionValue("i"));
        }
        if (cmdLine.hasOption("c")) {
            conf.setLinkHoverColor(cmdLine.getOptionValue("c"));
        }
        if (cmdLine.hasOption("x")) {
            conf.setTextColor(cmdLine.getOptionValue("x"));
        }
        if (cmdLine.hasOption("q")) {
            conf.setDisallowExit(true);
        }
        if (cmdLine.hasOption("I")) {
            conf.setDisableTaskTray(true);
        }
        if (cmdLine.hasOption("o")) {
            conf.setDisableTaskTrayBalloonTips(true);
        }
        if (cmdLine.hasOption("u")) {
            conf.setUserName(cmdLine.getOptionValue("u"));
            conf.setDisplayUserName(conf.getUserName());
        }
        if (cmdLine.hasOption("f")) {
            conf.setDefaultSelectedOption(ChargeToAccountType.fromClientConfigValue((String)cmdLine.getOptionValue("f")));
        }
        if (cmdLine.hasOption("F")) {
            conf.setDefaultSelectedAccount(cmdLine.getOptionValue("F"));
        }
        if (cmdLine.hasOption("P")) {
            conf.setDefaultSelectedAccountPin(cmdLine.getOptionValue("P"));
        }
        if (cmdLine.hasOption("T")) {
            conf.setAuthTTLValues(cmdLine.getOptionValue("T"));
        }
        if (cmdLine.hasOption("D")) {
            try {
                conf.setAuthTTLDefault(Integer.valueOf(cmdLine.getOptionValue("D")));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (cmdLine.hasOption("K")) {
            conf.setDoPreAuthentication(true);
        }
        if (cmdLine.hasOption("U")) {
            conf.setUsePreAuthentication(true);
        }
        if (cmdLine.hasOption("S")) {
            conf.setSharedSecretFile(cmdLine.getOptionValue("S"));
        }
        if (cmdLine.hasOption("C")) {
            conf.setClearAuthentication(true);
        }
        conf.setServerName(prop.getProperty("server-name"));
        conf.setServerIP(prop.getProperty("server-ip"));
        try {
            int serverPort = Integer.parseInt(prop.getProperty("server-port"));
            conf.setServerPort(serverPort);
        }
        catch (NumberFormatException e) {
            conf.setServerPort(-1);
        }
        try {
            int timeoutSecs = Integer.parseInt(prop.getProperty("connection-timeout-secs"));
            if (timeoutSecs > 0) {
                conf.setTimeoutSecs(timeoutSecs);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean hasValidServerDetails = false;
        if (StringUtils.isNotBlank((String)conf.getServerName()) && conf.getServerPort() > 0) {
            try {
                new URL("http", conf.getServerName(), conf.getServerPort(), "");
                hasValidServerDetails = true;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        String propServerURL = "server-url";
        String url = prop.getProperty("server-url");
        if (StringUtils.isNotBlank((String)url)) {
            try {
                URL u = new URL(url);
                conf.setServerName(u.getHost());
                conf.setServerPort(u.getPort());
                hasValidServerDetails = true;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (!hasValidServerDetails) {
            UserClient.exitWithError(UserClient.format("missing-server-details", new String[0]), conf.isSilent());
        }
        if (!conf.isDebugEnabled()) {
            String debugProp = "debug";
            String debug = prop.getProperty("debug");
            if (StringUtils.isNotBlank((String)debug)) {
                conf.setDebugEnabled(StringDataUtils.stringToBoolean((String)debug, (boolean)false));
            }
        }
        if (conf.isDebugEnabled()) {
            UserClient.initLogging(true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting client version: " + ApplicationInfo.getInstance().getFullVersionWithPlatformInfo()));
            String cmdString = "";
            for (String arg : args) {
                cmdString = cmdString + arg + " ";
            }
            logger.debug((Object)("Command line options: " + cmdString));
            logger.debug((Object)("Initial config: " + conf));
            logger.debug((Object)("System username: " + System.getProperty("user.name")));
            logger.debug((Object)("Config username: " + conf.getUserName()));
            logger.debug((Object)("Locale: " + Locale.getDefault()));
            Thread activityLogger = new Thread("activity-logger"){
                private final long _started = System.currentTimeMillis();

                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                            long uptimeMS = System.currentTimeMillis() - this._started;
                            logger.debug((Object)("Uptime: " + uptimeMS / 1000L + " secs"));
                        }
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)"Activity logger thread interrupted.");
                        logger.debug((Object)"Activity logger thread stopped.");
                        return;
                    }
                }
            };
            activityLogger.setDaemon(true);
            activityLogger.start();
        }
        return conf;
    }

    private static CommandLine parseCommandLine(String[] argsIn) {
        CommandLine cmdLine;
        String[] args = new String[argsIn.length];
        for (int i = 0; i < argsIn.length; ++i) {
            String arg = argsIn[i];
            if (arg.startsWith("/") && StringUtils.countMatches((String)arg, (String)"/") == 1) {
                arg = "--" + arg.substring(1);
            }
            args[i] = arg;
        }
        Options options = new Options();
        options.addOption("s", "silent", false, "Indicates the client should close quietly on error.");
        options.addOption("b", "debug", false, "Enable debug logging.");
        options.addOption("m", "minimized", false, "Start the client minimized.");
        options.addOption("B", "hide-balance", false, "Hide the user balance.");
        options.addOption("n", "neverrequestidentity", false, "Never display the identity conformation dialog if user does not exist. Sleep instead.");
        options.addOption("a", "requestidentity", false, "Display the identity conformation dialog.");
        options.addOption("l", "multiple", false, "Allow more than one instance per user.");
        options.addOption("w", "standardwinlaf", false, "Use standard Windows look and feel.");
        options.addOption("q", "noquit", false, "Do not allow the user to quit/close the client.");
        options.addOption("I", "disabletasktrayicon", false, "Hide the task tray icon");
        options.addOption("o", "disable-balloon-tips", false, "Disable balloon tips");
        options.addOption("K", "pre-authenticate", false, "Pre-authenticate a user given prior to starting");
        options.addOption("U", "use-pre-authentication", false, "Start client using the prior called pre-authentication");
        options.addOption("C", "clear-authentication", false, "Clear authentication then exit");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The user to run the client as.");
        OptionBuilder.withLongOpt((String)"user");
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)"shared-secret-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to the shared secret file to use for pre-authentication");
        OptionBuilder.withLongOpt((String)"shared-secret-file");
        options.addOption(OptionBuilder.create((String)"S"));
        OptionBuilder.withArgName((String)"lockdir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define an alternate lock directory location");
        OptionBuilder.withLongOpt((String)"lockdir");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"accounts-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The path to the file containing shared account data from the server.");
        OptionBuilder.withLongOpt((String)"accounts-file");
        options.addOption(OptionBuilder.create((String)"A"));
        OptionBuilder.withArgName((String)"windowposition");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The location of the window (top-right, top-left, bottom-right, bottom-left).");
        OptionBuilder.withLongOpt((String)"windowposition");
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"windowtitle");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The title to appear in the window.  If it includes the {0} placeholder, then this will be replaced by the user's username.");
        OptionBuilder.withLongOpt((String)"windowtitle");
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withArgName((String)"background-color");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The background color to use. In hexadecimal RGB, e.g. AA2400");
        OptionBuilder.withLongOpt((String)"background-color");
        options.addOption(OptionBuilder.create((String)"k"));
        OptionBuilder.withArgName((String)"text-color");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The text color to use. In hexadecimal RGB, e.g. AA2400");
        OptionBuilder.withLongOpt((String)"text-color");
        options.addOption(OptionBuilder.create((String)"x"));
        OptionBuilder.withArgName((String)"link-color");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The link color to use. In hexadecimal RGB, e.g. AA2400");
        OptionBuilder.withLongOpt((String)"link-color");
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withArgName((String)"link-hover-color");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The link mouseover color to use. In hexadecimal RGB, e.g. AA2400");
        OptionBuilder.withLongOpt((String)"link-hover-color");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"default-selection");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies the default selected option on the account selection popup. (charge-personal, charge-account-list, charge-account-pin, print-as-user).");
        OptionBuilder.withLongOpt((String)"default-selection");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"default-account");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies the default selected account on the account selection popup. Usually used in conjunction with default-selection=charge-account-list.");
        OptionBuilder.withLongOpt((String)"default-account");
        options.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withArgName((String)"default-account-pin");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specifies the default selected account pin on the account selection popup. Usually used in conjunction with default-selection=charge-account-pin.");
        OptionBuilder.withLongOpt((String)"default-account-pin");
        options.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withArgName((String)"auth-ttl-values");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The list authentication time-to-live options (comma separated)");
        OptionBuilder.withLongOpt((String)"auth-ttl-values");
        options.addOption(OptionBuilder.create((String)"T"));
        OptionBuilder.withArgName((String)"auth-ttl-default");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The default authentication TTL to use");
        OptionBuilder.withLongOpt((String)"auth-ttl-default");
        options.addOption(OptionBuilder.create((String)"D"));
        options.addOption("h", "help", false, "Displays this help.");
        PosixParser parser = new PosixParser();
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            cmdLine = null;
        }
        if (cmdLine == null || cmdLine.hasOption("h")) {
            HelpFormatter hf = new HelpFormatter();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            hf.printHelp(pw, 100, "pc-client [options]", null, options, 1, 3, null, false);
            System.out.print(sw.toString());
            try {
                JOptionPane.showMessageDialog(null, sw.toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
            System.exit(1);
        }
        return cmdLine;
    }

    private static void initLogging(boolean enableDebug) {
        Properties logProps = new Properties();
        if (enableDebug) {
            String LOG_FILE_NAME = "user-client.log";
            String logPath = "user-client.log";
            File dir = SystemUtils.IS_OS_MAC_OSX ? new File(NetworkUtils.getUserHomeDirectory()) : new File(System.getProperty("java.io.tmpdir"));
            if (dir.exists() && dir.isDirectory()) {
                logPath = new File(dir, "user-client.log").getAbsolutePath();
            }
            logProps.setProperty("log4j.appender.log", "org.apache.log4j.FileAppender");
            logProps.setProperty("log4j.appender.log.File", logPath);
        } else {
            logProps.setProperty("log4j.appender.log", "org.apache.log4j.ConsoleAppender");
            logProps.setProperty("log4j.appender.log.Target", "System.out");
        }
        logProps.setProperty("log4j.appender.log.layout", "org.apache.log4j.PatternLayout");
        logProps.setProperty("log4j.appender.log.layout.ConversionPattern", "%d{ISO8601} %5p %c{1}:%L - %m [%t]%n");
        logProps.setProperty("log4j.rootLogger", "off, log");
        if (StringUtils.isNotBlank((String)System.getProperty("papercut.dev-debug"))) {
            enableDebug = true;
        }
        String level = enableDebug ? "debug" : "off";
        logProps.setProperty("log4j.logger.biz.papercut", level);
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)logProps);
    }

    private static void exitWithError(final String msg, boolean silent) {
        logger.error((Object)("Exiting with error: " + msg));
        if (!silent) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DialogUtils.showErrorMessageDialog(null, (String)"", (String)msg);
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)("Exiting with error: " + msg));
            }
        }
        System.exit(1);
    }

    private static String format(String key, String ... args) {
        String fullKey = "UserClient." + key;
        return Messages.getString(UserClient.class, (String)fullKey, (String[])args);
    }

    public static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new RuntimeException("unbalanced quotes in " + toProcess);
        }
        return result.toArray(new String[result.size()]);
    }
}

