/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.util.NumberUtils;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentAccountsList {
    private LinkedList<Long> _queue = new LinkedList();
    private int _maxSize;

    public RecentAccountsList(int maxSize) {
        this._maxSize = maxSize;
    }

    public synchronized void loadFromString(String s) {
        this._queue = new LinkedList<Long>(NumberUtils.splitStringToLongList(s, ','));
    }

    public synchronized void add(Long l) {
        this._queue.remove(l);
        this._queue.addFirst(l);
        int oversize = this._queue.size() - this._maxSize;
        if (oversize > 0) {
            for (int i = 0; i < oversize; ++i) {
                this._queue.removeLast();
            }
        }
    }

    public synchronized List<Long> getRecent() {
        return this._queue;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._queue.size(); ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this._queue.get(i).toString());
        }
        return buf.toString();
    }
}

