/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.util.Messages;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthPanel
extends JPanel {
    private static final Log logger = LogFactory.getLog(AuthPanel.class);
    private JTextField _username;
    private JPasswordField _password;
    private JComboBox _ttl;
    private UserClientConfig _clientConfig;

    public AuthPanel(UserClientConfig clientConfig) {
        this._clientConfig = clientConfig;
        this.initComponents();
        this.layoutComponents();
        this._username.requestFocusInWindow();
    }

    private void initComponents() {
        this._username = new JTextField();
        this._password = new JPasswordField();
        String valuesStr = StringUtils.trimToEmpty((String)this._clientConfig.getAuthTTLValues());
        if (valuesStr.length() == 0) {
            valuesStr = StringUtils.trimToEmpty((String)this._clientConfig.getServerGlobalConfig().getAuthTTLValues());
        }
        if (valuesStr.length() == 0) {
            logger.debug((Object)"using default ttl values");
            valuesStr = "1,5,15,30,60,-1";
        }
        logger.debug((Object)("Auth TTL values: " + valuesStr));
        String[] valuesMinutes = valuesStr.split("\\s*,\\s*");
        ArrayList<TTLValue> values = new ArrayList<TTLValue>();
        for (int i = 0; i < valuesMinutes.length; ++i) {
            try {
                int val = Integer.parseInt(valuesMinutes[i]);
                if (val < 0) {
                    if (val == -1) {
                        values.add(new TTLValue(-1, AuthPanel.format("always", new String[0])));
                        continue;
                    }
                    if (val == -2) {
                        values.add(new TTLValue(-2, AuthPanel.format("indefinitely", new String[0])));
                        continue;
                    }
                    logger.debug((Object)"Unknown negative TTL value");
                    continue;
                }
                if (val == 0) {
                    values.add(new TTLValue(0, AuthPanel.format("for-this-job-only", new String[0])));
                    continue;
                }
                values.add(new TTLValue(val * 60, AuthPanel.format("minutes", Integer.toString(val))));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Unable to parse auth TTL value: " + valuesMinutes[i]));
            }
        }
        this._ttl = new JComboBox<Object>(values.toArray());
        int authDefault = this._clientConfig.getAuthTTLDefault() != null ? this._clientConfig.getAuthTTLDefault().intValue() : this._clientConfig.getServerGlobalConfig().getAuthTTLDefault();
        logger.debug((Object)("Auth TTL default: " + authDefault));
        if (authDefault < 0) {
            for (int i = 0; i < this._ttl.getItemCount(); ++i) {
                TTLValue v = (TTLValue)this._ttl.getItemAt(i);
                if (authDefault != v.getSeconds()) continue;
                this._ttl.setSelectedIndex(i);
                break;
            }
        } else {
            int defaultSeconds = authDefault * 60;
            for (int i = 0; i < this._ttl.getItemCount(); ++i) {
                TTLValue v = (TTLValue)this._ttl.getItemAt(i);
                if (v.getSeconds() != defaultSeconds) continue;
                this._ttl.setSelectedIndex(i);
                break;
            }
        }
    }

    private void layoutComponents() {
        FormLayout layout = new FormLayout("15dlu, right:max(pref;40dlu), 3dlu, max(pref;120dlu):grow, 20dlu", "0dlu:grow, pref, 3dlu, pref, 3dlu, pref, 0dlu:grow");
        layout.setRowGroups((int[][])new int[][]{{2, 4, 6}});
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.setRow(2);
        builder.setColumn(2);
        builder.append(AuthPanel.format("username", new String[0]), (Component)this._username);
        builder.nextLine(2);
        builder.setColumn(2);
        builder.append(AuthPanel.format("password", new String[0]), (Component)this._password);
        builder.nextLine(2);
        builder.setColumn(2);
        builder.append(AuthPanel.format("remember-for", new String[0]), (Component)this._ttl);
    }

    public String getUsername() {
        return this._username.getText();
    }

    public String getPassword() {
        return new String(this._password.getPassword());
    }

    public int getTimeToLiveSeconds() {
        return ((TTLValue)this._ttl.getSelectedItem()).getSeconds();
    }

    public void setDefaultTTLSecs(int secs) {
        for (int i = 0; i < this._ttl.getItemCount(); ++i) {
            TTLValue v = (TTLValue)this._ttl.getItemAt(i);
            if (v.getSeconds() < secs) continue;
            this._ttl.setSelectedIndex(i);
        }
    }

    private static String format(String key, String ... args) {
        String fullKey = "AuthPanel." + key;
        return Messages.getString(AuthPanel.class, (String)fullKey, (String[])args);
    }

    private static class TTLValue {
        private int _seconds;
        private String _description;

        public TTLValue(int seconds, String description) {
            this._seconds = seconds;
            this._description = description;
        }

        public String getDescription() {
            return this._description;
        }

        public void setDescription(String description) {
            this._description = description;
        }

        public int getSeconds() {
            return this._seconds;
        }

        public void setSeconds(int seconds) {
            this._seconds = seconds;
        }

        public String toString() {
            return this._description;
        }
    }
}

