/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.common.ChargeRate;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientAccountFile;
import biz.papercut.pcng.common.ClientAction;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.common.ClientJobUpdateResponse;
import biz.papercut.pcng.common.ClientPopupInfo;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.ClientPrintPopupConfig;
import biz.papercut.pcng.common.ClientUserConfigFromServer;
import biz.papercut.pcng.common.UserDetails;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequestWithJobInfo;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnection {
    private static final Log logger = LogFactory.getLog(ServerConnection.class);
    private static final String RPC_PATH = "/rpc/clients/xmlrpc";
    private static final String IP_ADDRESS_SEPARATOR = ",";
    private XmlRpcClient _xmlRpcClient;
    private XmlRpcClient _secureXmlRpcClient;
    private String _serverName;
    private String _serverIP;
    private int _serverPort;
    private boolean _useIP;
    private int _sslPort;
    private String _userName;
    private String _machineName;
    private String _allIpAddresses;
    private long _ipAddressCacheExpiryTime;
    private boolean _connected;
    private static final long IP_CACHE_TIMEOUT_MILLIS = 60000L;

    public ServerConnection(String serverName, String serverIP, int serverPort, int timeoutSecs, boolean retryUntilConnect) {
        block8: {
            this._secureXmlRpcClient = null;
            this._useIP = false;
            this._sslPort = -1;
            this._userName = null;
            this._machineName = "";
            this._allIpAddresses = "";
            this._ipAddressCacheExpiryTime = 0L;
            this._connected = false;
            this._serverName = serverName;
            this._serverIP = serverIP;
            this._serverPort = serverPort;
            this._machineName = StringUtils.trimToEmpty((String)NetworkUtils.getComputerName());
            this.loadAllIpAddressesIfRequired();
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(timeoutSecs * 1000));
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(timeoutSecs * 1000));
            XmlRpc.setKeepAlive((boolean)true);
            XmlRpc.setDefaultInputEncoding((String)"UTF8");
            XmlRpc.setEncoding((String)"UTF8");
            double perturbation = new Random().nextDouble();
            double retryDelayIncrementSecs = 1.0 + perturbation;
            double retryDelaySecs = 4.0 + 2.0 * perturbation;
            double maxRetryDelaySecs = 30.0;
            while (true) {
                boolean pass = false;
                URL url = null;
                try {
                    url = new URL("http", serverName, serverPort, RPC_PATH);
                    logger.debug((Object)("Attempting to connect using server's name: " + url));
                    this._xmlRpcClient = new XmlRpcClient(url);
                    pass = this.ping();
                }
                catch (Exception e) {
                    logger.debug((Object)("Failed to connect to server using server name. " + e.getMessage()), (Throwable)e);
                    pass = false;
                }
                if (!pass) {
                    try {
                        this._useIP = true;
                        url = new URL("http", serverIP, serverPort, RPC_PATH);
                        logger.debug((Object)("Attempting to connect using server's IP: " + url));
                        this._xmlRpcClient = new XmlRpcClient(url);
                        pass = this.ping();
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Failed to connect to server using ip address. " + e.getMessage()), (Throwable)e);
                        pass = false;
                    }
                }
                if (pass) break block8;
                if (!retryUntilConnect) break;
                try {
                    logger.debug((Object)("Retry connection in: " + retryDelaySecs + " secs."));
                    Thread.sleep((int)(retryDelaySecs * 1000.0));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!((retryDelaySecs += retryDelayIncrementSecs) > 30.0)) continue;
                retryDelaySecs = 30.0;
            }
            logger.error((Object)("Unable to establish connection with server: " + serverName));
            throw new ServerConnectionException("Unable to establish connection with the server: " + serverName);
        }
        this._connected = true;
    }

    private void setupSecureConnection() {
        if (this._sslPort <= 0) {
            logger.error((Object)"Invalid SSL port so not setting up SSL connection.");
            return;
        }
        try {
            NetworkUtils.setupHTTPSToIgnoreHostnameAndTrustErrors();
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)"Invalid SSL Setup.", (Throwable)e);
            return;
        }
        URL url = null;
        String server = null;
        server = this._useIP ? this._serverIP : this._serverName;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Configuring SSL connection to: " + server + ":" + this._sslPort));
            }
            url = new URL("https", server, this._sslPort, RPC_PATH);
        }
        catch (MalformedURLException e) {
            throw new ServerConnectionException("Invalid URL.", e);
        }
        XmlRpc.setKeepAlive((boolean)true);
        XmlRpc.setDefaultInputEncoding((String)"UTF8");
        XmlRpc.setEncoding((String)"UTF8");
        this._secureXmlRpcClient = new XmlRpcClient(url);
    }

    public List<ClientAction> getPendingActions(int timeoutSecs) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requesting pending actions for: " + this.getUserName()));
        }
        boolean actionInfoLevel = true;
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(timeoutSecs);
        params.add(1);
        Vector actionStrings = (Vector)this.execute("client.getPendingActions", params, false);
        if (actionStrings.size() == 0) {
            return Collections.emptyList();
        }
        logger.debug((Object)("Got " + actionStrings.size() + " pending actions."));
        ArrayList<ClientAction> actions = new ArrayList<ClientAction>(actionStrings.size());
        for (String actionString : actionStrings) {
            try {
                actions.add(ClientAction.valueOf((String)actionString));
            }
            catch (IllegalArgumentException e) {
                logger.debug((Object)("Unknown action type: " + actionString));
            }
        }
        return actions;
    }

    public boolean ping() {
        logger.debug((Object)"Pinging server");
        Vector<Object> params = new Vector<Object>();
        Boolean r = (Boolean)this.execute("client.ping", params, false);
        return r;
    }

    public Vector<String> getPendingMessages() {
        logger.debug((Object)("Requesting pending messages for: " + this.getUserName()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        Vector msgs = (Vector)this.execute("client.getUserMessages", params, false);
        logger.debug((Object)("Got " + msgs.size() + " pending messages."));
        return msgs;
    }

    public List<ClientPrintJob> getPendingPrintJobs() {
        logger.debug((Object)("Requesting pending print jobs for: " + this.getUserName()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        Vector result = (Vector)this.execute("client.getPendingPrintJobs", params, false);
        logger.debug((Object)("Got " + result.size() + " pending print jobs."));
        ArrayList<ClientPrintJob> jobs = new ArrayList<ClientPrintJob>(result.size());
        for (Hashtable jobHash : result) {
            jobs.add(new ClientPrintJob(jobHash));
        }
        return jobs;
    }

    public int getPendingPrintJobCount() {
        logger.debug((Object)("Requesting pending print job count for: " + this.getUserName()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        Integer result = (Integer)this.execute("client.getPendingPrintJobCount", params, false);
        return result;
    }

    public void getUpdatedPrintJobInfo(ClientPrintJob job) {
        logger.debug((Object)("Getting updating job info for: " + job.getJobId()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        Hashtable result = (Hashtable)this.execute("client.getPrintJobInfo", params, false);
        if (result.size() == 0) {
            logger.debug((Object)("No updated job info returned for job id: " + job.getJobId()));
            return;
        }
        ClientPrintJob updatedJob = new ClientPrintJob(result);
        job.setDocumentName(updatedJob.getDocumentName());
        job.setFormattedCost(updatedJob.getFormattedCost());
        job.setPreNotification(updatedJob.isPreNotification());
        job.setPrinterName(updatedJob.getPrinterName());
        job.setServerName(updatedJob.getServerName());
        job.setTotalPages(updatedJob.getTotalPages());
        job.setColorPages(updatedJob.getColorPages());
    }

    public void cancelPendingPrintJob(ClientPrintJob job, boolean cancelAllPending) {
        if (cancelAllPending) {
            this.updateAllPendingPrintJobs(job, true, new ClientPopupInfo());
        } else {
            this.updatePendingPrintJob(job, true, new ClientPopupInfo());
        }
    }

    public ClientJobUpdateResponse updatePendingPrintJob(ClientPrintJob job, boolean cancelPrint, ClientPopupInfo popupInfo) {
        logger.debug((Object)("Updating print job: " + job.getJobId()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        params.add(cancelPrint);
        params.add(this.buildAccountSelectionArgs(cancelPrint, popupInfo));
        Vector result = null;
        result = StringUtils.isNotBlank((String)popupInfo.getPassword()) || StringUtils.isNotBlank((String)popupInfo.getAccountPin()) ? (Vector)this.execute("client.updatePendingPrintJob", params, true) : (Vector)this.execute("client.updatePendingPrintJob", params, false);
        if (((Boolean)result.get(0)).booleanValue()) {
            return new ClientJobUpdateResponse(true, false, "");
        }
        return new ClientJobUpdateResponse(((Boolean)result.get(0)).booleanValue(), ((Boolean)result.get(1)).booleanValue(), (String)result.get(2));
    }

    public ClientJobUpdateResponse updateAllPendingPrintJobs(ClientPrintJob firstJob, boolean cancelPrint, ClientPopupInfo popupInfo) {
        logger.debug((Object)("Updating all print jobs. First JobId: " + firstJob.getJobId()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(firstJob.getJobId());
        params.add(cancelPrint);
        params.add(this.buildAccountSelectionArgs(cancelPrint, popupInfo));
        Hashtable result = null;
        result = StringUtils.isNotBlank((String)popupInfo.getPassword()) || StringUtils.isNotBlank((String)popupInfo.getAccountPin()) ? (Hashtable)this.execute("client.updateAllPendingPrintJobs", params, true) : (Hashtable)this.execute("client.updateAllPendingPrintJobs", params, false);
        ClientJobUpdateResponse response = new ClientJobUpdateResponse(result);
        return response;
    }

    public String getUsersRecentAccounts(ClientPrintJob job) {
        logger.debug((Object)("Getting recent accounts for user associated with jobid: " + job.getJobId()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        String accounts = (String)this.execute("client.getUsersRecentAccounts", params, false);
        logger.debug((Object)("Got recent accounts: " + accounts));
        return accounts;
    }

    public String getUsersPreferredAccounts(ClientPrintJob job) {
        logger.debug((Object)("Getting prefered accounts for user associated with jobid: " + job.getJobId()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        String accounts = (String)this.execute("client.getUsersPreferredAccounts", params, false);
        logger.debug((Object)("Got Preferred accounts: " + accounts));
        return accounts;
    }

    public void setUsersPreferredAccounts(ClientPrintJob job, String preferredAccounts) {
        logger.debug((Object)("Setting prefered accounts for user associated with jobid: " + job.getJobId()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        params.add(preferredAccounts);
        Boolean ret = (Boolean)this.execute("client.setUsersPreferredAccounts", params, false);
        if (!ret.booleanValue()) {
            throw new ServerConnectionException("Problem setting user's preferred Accounts");
        }
    }

    public List<ChargeRate> getChargeRates(ClientPrintJob job) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        params.add(2);
        String rateStr = (String)this.execute("client.getChargeRates3", params, false);
        List l = ChargeRate.stringToList((String)rateStr);
        return l;
    }

    public ClientAuthResponse authenticateUser(String userName, String password, int preferredTTLSecs) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(userName);
        params.add(password);
        params.add(preferredTTLSecs);
        Hashtable result = (Hashtable)this.execute("client.authenticateUser", params, true);
        ClientAuthResponse response = new ClientAuthResponse(result);
        return response;
    }

    public ClientAuthResponse authenticateUserWithSharedSecret(String userName, String sharedSecret, int preferredTTLSecs) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(userName);
        params.add(sharedSecret);
        params.add(preferredTTLSecs);
        Hashtable result = (Hashtable)this.execute("client.authenticateUserWithSharedSecret", params, true);
        ClientAuthResponse response = new ClientAuthResponse(result);
        return response;
    }

    public ClientAuthResponse authenticateUserWithCookie(String authCookie) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(authCookie);
        Hashtable result = (Hashtable)this.execute("client.authenticateUserWithCookie", params, true);
        ClientAuthResponse response = new ClientAuthResponse(result);
        return response;
    }

    public boolean clearAuthentication() {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        boolean result = (Boolean)this.execute("client.clearAuthentication", params, false);
        return result;
    }

    public ClientAuthResponse checkIdentity(String userName, String password) {
        Vector<Object> params = new Vector<Object>();
        params.add(userName);
        params.add(password);
        Hashtable result = (Hashtable)this.execute("client.checkIdentity", params, true);
        ClientAuthResponse response = new ClientAuthResponse(result);
        return response;
    }

    private Hashtable<String, Object> buildAccountSelectionArgs(boolean cancelPrint, ClientPopupInfo popupInfo) {
        Hashtable<String, Object> args = new Hashtable<String, Object>();
        if (!cancelPrint) {
            if (popupInfo.getChargeToAccountType() == null) {
                popupInfo.setChargeToAccountType(ChargeToAccountType.PersonalAccount);
            }
            args.put("account-to-charge-type", popupInfo.getChargeToAccountType().name());
            switch (popupInfo.getChargeToAccountType()) {
                case PersonalAccount: {
                    break;
                }
                case AccountWithPin: {
                    args.put("account-pin", ClientPopupInfo.encodePassword((String)popupInfo.getAccountPin()));
                    break;
                }
                case AccountFromList: {
                    args.put("account-id", String.valueOf(popupInfo.getAccountId()));
                    break;
                }
                case OtherUser: {
                    args.put("username", popupInfo.getUserName());
                    args.put("password", ClientPopupInfo.encodePassword((String)popupInfo.getPassword()));
                    break;
                }
                case ManagerPrint: {
                    args.put("username", popupInfo.getUserName());
                    if (StringUtils.isNotBlank((String)popupInfo.getAccountPin())) {
                        args.put("account-pin", ClientPopupInfo.encodePassword((String)popupInfo.getAccountPin()));
                        break;
                    }
                    args.put("account-id", String.valueOf(popupInfo.getAccountId()));
                    break;
                }
                default: {
                    logger.error((Object)("Unknown handled account charge-to type: " + popupInfo.getChargeToAccountType()));
                }
            }
        }
        if (StringUtils.isNotBlank((String)popupInfo.getComment())) {
            args.put("job-comment", popupInfo.getComment());
        }
        if (popupInfo.getInvoice() != null) {
            args.put("job-invoice", popupInfo.getInvoice());
        }
        if (popupInfo.getChargeRates() != null && popupInfo.getChargeRates().size() > 0) {
            args.put("charge-rate", ChargeRate.listToString((List)popupInfo.getChargeRates(), (boolean)false));
        }
        return args;
    }

    private synchronized void appendClientIdentityParams(Vector<Object> params) {
        this.loadAllIpAddressesIfRequired();
        if (StringUtils.isBlank((String)this.getUserName())) {
            throw new ApplicationException("setUserName() must be set when calling this method");
        }
        params.add(this.getUserName());
        params.add(this.getMachineName());
        params.add(this.getAllIpAddresses());
    }

    private synchronized void loadAllIpAddressesIfRequired() {
        if (System.currentTimeMillis() > this._ipAddressCacheExpiryTime) {
            String _previousIpAddresses = this._allIpAddresses;
            StringBuilder sb = new StringBuilder();
            for (String ip : NetworkUtils.getAllIpAddresses()) {
                if (sb.length() > 0) {
                    sb.append(IP_ADDRESS_SEPARATOR);
                }
                sb.append(ip);
            }
            this._allIpAddresses = sb.toString();
            this._ipAddressCacheExpiryTime = System.currentTimeMillis() + 60000L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Client's list of IP addresses is: " + this._allIpAddresses + ". " + (this._allIpAddresses.equals(_previousIpAddresses) ? " Unchanged." : " Previously: " + _previousIpAddresses)));
            }
        }
    }

    public ClientGlobalConfigFromServer getGlobalConfig() {
        logger.debug((Object)"Requesting global config data from server");
        Vector<Object> params = new Vector<Object>();
        params.add(this.getMachineName());
        params.add(this.getAllIpAddresses());
        Hashtable data = (Hashtable)this.execute("client.getGlobalConfig", params, false);
        ClientGlobalConfigFromServer cc = new ClientGlobalConfigFromServer(data);
        logger.debug((Object)("SSL Port: " + cc.getSslPort()));
        if (cc.getSslPort() > 0) {
            this._sslPort = cc.getSslPort();
            this.setupSecureConnection();
        }
        return cc;
    }

    public ClientUserConfigFromServer getUserConfig() {
        logger.debug((Object)"Requesting user config data from server");
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        Hashtable data = (Hashtable)this.execute("client.getUserConfig", params, false);
        return new ClientUserConfigFromServer(data);
    }

    public boolean userExists(String userName) {
        Vector<Object> params = new Vector<Object>();
        params.add(userName);
        return (Boolean)this.execute("client.userExists", params, false);
    }

    public String getUserBalance(String userName) {
        logger.debug((Object)("Requesting user balance for user: " + userName));
        Vector<Object> params = new Vector<Object>(3);
        this.appendClientIdentityParams(params);
        params.add(userName);
        String balance = (String)this.execute("client.getUserBalance", params, false);
        logger.debug((Object)("Got the balance: " + balance));
        return balance;
    }

    public UserDetails getUserDetails(String userNameOrId, boolean lookupID) {
        Vector<Object> params = new Vector<Object>(3);
        this.appendClientIdentityParams(params);
        params.add(userNameOrId);
        params.add(lookupID);
        Hashtable data = (Hashtable)this.execute("client.getUserDetails", params, false);
        if (data.size() == 0) {
            return null;
        }
        return new UserDetails(data);
    }

    public ClientPrintPopupConfig getPrintJobPopupConfig(ClientPrintJob job) {
        logger.debug((Object)("Requesting print job popup config for user " + this.getUserName() + " and job id " + job.getJobId()));
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        Hashtable data = (Hashtable)this.execute("client.getPrintJobPopupConfig", params, false);
        return new ClientPrintPopupConfig(data);
    }

    public String getUserAccountsLastModifiedTime(ClientPrintJob job) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        return (String)this.execute("client.getUserAccountsLastModifiedTime", params, false);
    }

    public List<ClientAccount> getUserAccounts(ClientPrintJob job, String username) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(job.getJobId());
        params.add(3);
        byte[] data = (byte[])this.execute("client.getUserAccountsFile", params, false);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return ClientAccountFile.readClientAccountsFromStream((InputStream)bais, (int)3);
        }
        catch (IOException e) {
            throw new ApplicationException("Error loading accounts from server: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ClientAccount> getAllSharedAccounts() {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(3);
        byte[] data = (byte[])this.execute("client.getAllSharedAccountsFile", params, false);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return ClientAccountFile.readClientAccountsFromStream((InputStream)bais, (int)3);
        }
        catch (IOException e) {
            throw new ApplicationException("Error loading accounts from server: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ClientDialogRequestWithJobInfo> getPendingClientDialogs() {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        Vector v = (Vector)this.execute("client.getClientDialogs", params, false);
        ArrayList<ClientDialogRequestWithJobInfo> r = new ArrayList<ClientDialogRequestWithJobInfo>(v.size());
        for (Object data : v) {
            try {
                ClientDialogRequestWithJobInfo d = new ClientDialogRequestWithJobInfo((Vector)data);
                if (d.getRequest() == null) {
                    logger.error((Object)("Unknown dialog type, client must be upgraded. Dialog data: " + data));
                    DialogUtils.showWarningMessageDialog(null, (String)Messages.getString(this.getClass(), (String)"UserClient.message", (String[])new String[0]), (String)Messages.getString(this.getClass(), (String)"UserClient.unknown-dialog", (String[])new String[0]));
                    continue;
                }
                r.add(d);
            }
            catch (Exception e) {
                logger.error((Object)("Error occurred process dialog: " + data), (Throwable)e);
            }
        }
        return r;
    }

    public void setClientDialogResponse(String printEventID, String uniqueID, ClientDialogResponse response) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params);
        params.add(printEventID);
        params.add(uniqueID);
        params.add(response.saveToHashtable());
        this.execute("client.setClientDialogResponse", params, false);
    }

    private Object execute(String method, Vector<Object> parameters, boolean useSecureIfAvailable) {
        try {
            boolean hasCalled = false;
            Object result = null;
            long startTime = System.currentTimeMillis();
            if (useSecureIfAvailable && this._secureXmlRpcClient != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Calling secure method: " + method + " (parameters suppressed)"));
                    }
                    result = this._secureXmlRpcClient.execute(method, parameters);
                    hasCalled = true;
                }
                catch (Exception e) {
                    logger.debug((Object)"Unable to call secure method.", (Throwable)e);
                }
            }
            if (!hasCalled) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Calling method: " + method + "(" + parameters + ")"));
                }
                result = this._xmlRpcClient.execute(method, parameters);
            }
            if (logger.isDebugEnabled()) {
                String resultStr = null;
                if (result instanceof Collection) {
                    Collection c = (Collection)result;
                    if (c.size() > 50) {
                        resultStr = "[not displayed, too large: " + c.size() + "]";
                    }
                } else if (result instanceof Map) {
                    Map c = (Map)result;
                    if (c.size() > 50) {
                        resultStr = "[not displayed, too large: " + c.size() + "]";
                    }
                } else if (result instanceof byte[]) {
                    resultStr = "[byte array length " + ((byte[])result).length + "]";
                }
                if (resultStr == null) {
                    resultStr = String.valueOf(result);
                }
                logger.debug((Object)("Call to method: " + method + " took " + (System.currentTimeMillis() - startTime) + " ms. Result: " + resultStr));
            }
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)((Object)result);
            }
            return result;
        }
        catch (XmlRpcException e) {
            throw new ServerConnectionException(e.getMessage() + " Method: " + method + " Params: " + parameters, e);
        }
        catch (IOException e) {
            throw new ServerConnectionException("Problem communicating with server: " + e.getMessage(), e);
        }
    }

    public String getConnectionName() {
        if (!this._connected) {
            throw new ApplicationException("It is only valid to call this method on an open connection");
        }
        if (this._useIP) {
            return this._serverIP;
        }
        return this._serverName;
    }

    public int getConnectionPort() {
        if (!this._connected) {
            throw new ApplicationException("It is only valid to call this method on an open connection");
        }
        return this._serverPort;
    }

    private synchronized String getMachineName() {
        return this._machineName;
    }

    public synchronized String getUserName() {
        return this._userName;
    }

    public synchronized void setUserName(String userName) {
        this._userName = userName;
    }

    public synchronized String getAllIpAddresses() {
        return this._allIpAddresses;
    }

    public static class ServerConnectionException
    extends ApplicationException {
        public ServerConnectionException(String message) {
            super(message);
        }

        public ServerConnectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

