/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.retrotranslator.runtime.asm.ClassReader;

public class ClassReaderFactory {
    private boolean useClasspath;
    private List entries = new ArrayList();
    private Map cache = new HashMap();

    public ClassReaderFactory(boolean bl) {
        this.useClasspath = bl;
    }

    public void appendPath(File file) {
        if (!file.exists()) {
            throw new RuntimeException(file.getPath() + " not found.");
        }
        this.entries.add(file.isDirectory() ? new DirectoryEntry(file) : new ZipFileEntry(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassReader getClassReader(String string) throws ClassNotFoundException {
        ClassReader classReader;
        ClassReader classReader2;
        Object object;
        if (this.cache.containsKey(string)) {
            object = (SoftReference)this.cache.get(string);
            if (object == null) {
                throw new ClassNotFoundException(string);
            }
            classReader2 = (ClassReader)((SoftReference)object).get();
            if (classReader2 != null) {
                return classReader2;
            }
        }
        if ((object = this.getStream(string + ".class")) == null) {
            this.cache.put(string, null);
            throw new ClassNotFoundException(string);
        }
        try {
            classReader2 = new ClassReader((InputStream)object);
            this.cache.put(string, new SoftReference<ClassReader>(classReader2));
            classReader = classReader2;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        ((InputStream)object).close();
        return classReader;
    }

    private InputStream getStream(String string) {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            InputStream inputStream = entry.getResourceAsStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return this.useClasspath ? this.getClass().getClassLoader().getResourceAsStream(string) : null;
    }

    public void close() {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            try {
                entry.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class ZipFileEntry
    implements Entry {
        private ZipFile zipFile;

        public ZipFileEntry(File file) {
            try {
                this.zipFile = new ZipFile(file);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public InputStream getResourceAsStream(String string) {
            ZipEntry zipEntry = this.zipFile.getEntry(string);
            try {
                return zipEntry == null ? null : this.zipFile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public void close() {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private static class DirectoryEntry
    implements Entry {
        private File directory;

        public DirectoryEntry(File file) {
            this.directory = file;
        }

        public InputStream getResourceAsStream(String string) {
            try {
                return new FileInputStream(new File(this.directory, string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        public void close() {
        }
    }

    private static interface Entry {
        public InputStream getResourceAsStream(String var1);

        public void close();
    }
}

