/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.transformer.ClassReaderFactory;
import net.sf.retrotranslator.transformer.MessageLogger;
import net.sf.retrotranslator.transformer.ReferenceVerifyingVisitor;
import net.sf.retrotranslator.transformer.TransformerTools;

public class ClassVerifier {
    private ClassReaderFactory factory;

    public ClassVerifier(ClassReaderFactory classReaderFactory) {
        this.factory = classReaderFactory;
    }

    public boolean verify(File file, List list, MessageLogger messageLogger) {
        messageLogger.info("Verifying " + list.size() + " file(s) in " + file + ".");
        ReferenceVerifyingVisitor referenceVerifyingVisitor = new ReferenceVerifyingVisitor(this.factory, messageLogger);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            messageLogger.verbose(string);
            byte[] byArray = TransformerTools.readFileToByteArray(new File(file, string));
            new ClassReader(byArray).accept((ClassVisitor)referenceVerifyingVisitor, true);
        }
        int n = referenceVerifyingVisitor.getWarningCount();
        messageLogger.info("Verification of " + list.size() + " file(s) completed" + (n != 0 ? " with " + n + " warning(s)." : " successfully."));
        return n == 0;
    }
}

