/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.retrotranslator.transformer.ClassReaderFactory;
import net.sf.retrotranslator.transformer.ClassTransformer;
import net.sf.retrotranslator.transformer.ClassVerifier;
import net.sf.retrotranslator.transformer.MessageLogger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class RetrotranslatorTask
extends MatchingTask
implements MessageLogger {
    private Path src;
    private File destdir;
    private boolean verbose;
    private boolean stripsign;
    private boolean verify;
    private boolean failonwarning = true;
    private Path classpath;

    public RetrotranslatorTask() {
        this.setIncludes("**/*.class");
    }

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setStripsign(boolean bl) {
        this.stripsign = bl;
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public void setFailonwarning(boolean bl) {
        this.failonwarning = bl;
    }

    public void setClasspathref(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        if (this.destdir != null) {
            if (!this.destdir.exists()) {
                throw new BuildException(this.destdir + " not found.");
            }
            if (!this.destdir.isDirectory()) {
                throw new BuildException(this.destdir + " is not a directory.");
            }
        }
        List list = this.getFileCollection();
        ClassTransformer classTransformer = new ClassTransformer(this.stripsign);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FileCollection fileCollection = (FileCollection)iterator.next();
            classTransformer.transform(fileCollection.dir, this.getDestDir(fileCollection), fileCollection.fileNames, this);
        }
        if (this.verify) {
            this.verifyAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAll(List list) {
        ClassReaderFactory classReaderFactory = new ClassReaderFactory(this.classpath == null);
        try {
            Object object;
            int n;
            Object object2;
            if (this.classpath != null) {
                object2 = this.classpath.list();
                n = ((String[])object2).length;
                for (int i = 0; i < n; ++i) {
                    object = object2[i];
                    classReaderFactory.appendPath(this.getProject().resolveFile((String)object));
                }
            }
            new Path(this.getProject()).concatSystemClasspath();
            if (this.destdir != null) {
                classReaderFactory.appendPath(this.destdir);
            } else {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    FileCollection fileCollection = (FileCollection)object2.next();
                    classReaderFactory.appendPath(fileCollection.dir);
                }
            }
            object2 = new ClassVerifier(classReaderFactory);
            n = 1;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (FileCollection)iterator.next();
                n &= ((ClassVerifier)object2).verify(this.getDestDir((FileCollection)object), ((FileCollection)object).fileNames, this);
            }
            if (n == 0 && this.failonwarning) {
                throw new BuildException("Verification failed.", this.getLocation());
            }
        }
        finally {
            classReaderFactory.close();
        }
    }

    private File getDestDir(FileCollection fileCollection) {
        return this.destdir != null ? this.destdir : fileCollection.dir;
    }

    private List getFileCollection() {
        ArrayList<FileCollection> arrayList = new ArrayList<FileCollection>();
        if (this.src != null) {
            String[] stringArray = this.src.list();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                File file = this.getProject().resolveFile(string);
                String[] stringArray2 = this.getDirectoryScanner(file).getIncludedFiles();
                arrayList.add(new FileCollection(file, Arrays.asList(stringArray2)));
            }
        }
        if (arrayList.isEmpty()) {
            throw new BuildException("Source directory is not set.");
        }
        return arrayList;
    }

    public void verbose(String string) {
        if (this.verbose) {
            this.log(string, 2);
        }
    }

    public void info(String string) {
        this.log(string, 2);
    }

    public void warning(String string) {
        this.log(string, 1);
    }

    private static class FileCollection {
        public final File dir;
        public final List fileNames;

        public FileCollection(File file, List list) {
            this.dir = file;
            this.fileNames = list;
        }
    }
}

