/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationEdition;
import biz.papercut.pcng.util.LocaleUtils;
import biz.papercut.pcng.util.PlatformInfo;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationInfo {
    private static final Log logger = LogFactory.getLog(ApplicationInfo.class);
    private static final String KEY_APP_EDITION = "application.edition";
    private static final String KEY_APP_NAME = "application.name";
    private static final String KEY_APP_URL = "application.url";
    private static final String KEY_APP_UPDATE_URL = "application.update-check-url";
    private static final String KEY_APP_UPDATE_CHECK_DAYS = "application.update-check-days";
    private static final String KEY_APP_LICENSING_URL = "application.licensing-url";
    private static final String KEY_KNOWLEDGE_BASE_URL = "application.knowledge-base-url";
    private static final String KEY_APP_TOPUP_CARD_NAME = "application.topup-card-name";
    private static final String KEY_VERSION_MAJOR = "version.major";
    private static final String KEY_VERSION_MINOR = "version.minor";
    private static final String KEY_VERSION_SUFFIX = "version.suffix";
    private static final String KEY_VERSION_RELEASE_DATES = "version.release-dates";
    private static final String KEY_VERSION_GRACE_PERIOD_START_DATES = "version.grace-period-start-dates";
    private static final String KEY_BUILD_ID = "build.id";
    private static final String KEY_BUILD_DATE = "build.date";
    private static final String KEY_SUPPORT_URL = "support.url";
    private static final String KEY_SUPPORT_EMAIL = "support.email";
    private static final String KEY_PREMIUM_SUPPORT_EMAIL = "premium-support.email";
    private static final String KEY_SUPPORT_VENDOR = "support.vendor";
    private static final String KEY_SUPPORT_NEWS_URL = "support.news-url";
    private static final String KEY_SUPPORT_MANUAL_URL = "support.manual-url";
    private static final String KEY_ERROR_REPORT_URL = "error.report.url";
    private static final String KEY_COPYRIGHT_OWNER = "copyright.owner";
    private static final String KEY_TRANSLATIONS_PARTIAL = "translations.partial";
    private static final String KEY_TRANSLATIONS_COMPLETE = "translations.complete";
    private static final String KEY_MODULES = "modules";
    private static final String KEY_LICENSE_VERSION_GRACE_MONTHS = "license.version.grace-months";
    private static final String KEY_BRAND = "brand";
    private static final String INFO_RESOURCE = "/biz/papercut/application.properties";
    private static final String BUILD_RESOURCE = "/ng-build.properties";
    private static ApplicationInfo _instance = null;
    private final Properties _props;
    private String _resellerId = null;
    private final boolean _developmentMode = StringUtils.endsWith((String)System.getProperty("server.home"), (String)"working");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationInfo() {
        this._props = new Properties();
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(INFO_RESOURCE);
            this._props.load(in);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to load application.properties");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        try {
            in = this.getClass().getResourceAsStream(BUILD_RESOURCE);
            this._props.load(in);
        }
        catch (Exception exception) {
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static synchronized ApplicationInfo getInstance() {
        if (_instance == null) {
            _instance = new ApplicationInfo();
        }
        return _instance;
    }

    public synchronized String getResellerId() {
        return this._resellerId;
    }

    public synchronized void setResellerId(String resellerId) {
        this._resellerId = resellerId;
    }

    public ApplicationEdition getApplicationEdition() {
        ApplicationEdition edition = null;
        try {
            edition = ApplicationEdition.valueOf(this._props.getProperty(KEY_APP_EDITION));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (edition == null) {
            logger.error((Object)("Unable to determine application edition, assuming NG. Value: " + this._props.getProperty(KEY_APP_EDITION)));
            edition = ApplicationEdition.NG;
        }
        return edition;
    }

    public boolean isPaperCutBrand() {
        return this.getApplicationBrand().equals("papercut") || this.getApplicationBrand().equals("chargeback") || this.getApplicationBrand().equals("papercut-mf");
    }

    public boolean isFirstGenOEMBrand() {
        return this.getApplicationBrand().equals("paper-less-pro") || this.getApplicationBrand().startsWith("print-trac") || this.getApplicationBrand().equals("exgen");
    }

    public String getApplicationBrand() {
        return this._props.getProperty(KEY_BRAND);
    }

    public String getApplicationName() {
        return this._props.getProperty(KEY_APP_NAME);
    }

    public String getApplicationURL() {
        return this._props.getProperty(KEY_APP_URL);
    }

    public String getUpdateCheckURL() {
        return this._props.getProperty(KEY_APP_UPDATE_URL);
    }

    public String getLicensingURL() {
        return this.findResellerSpecificProperty(KEY_APP_LICENSING_URL);
    }

    public String getTopupCardName() {
        return this._props.getProperty(KEY_APP_TOPUP_CARD_NAME);
    }

    public int getMinorVersion() {
        return this.getIntProperty(KEY_VERSION_MINOR);
    }

    public int getMajorVersion() {
        return this.getIntProperty(KEY_VERSION_MAJOR);
    }

    public String getVersionSuffix() {
        return this._props.getProperty(KEY_VERSION_SUFFIX, "");
    }

    public String getReleaseDatesString() {
        return this._props.getProperty(KEY_VERSION_RELEASE_DATES, "");
    }

    public String getReleaseUpgradeGracePeriodStartDatesString() {
        return this._props.getProperty(KEY_VERSION_GRACE_PERIOD_START_DATES, "");
    }

    public Map<Integer, Date> getReleaseDates() {
        String s = this.getReleaseDatesString();
        return this.parseVersionDates(s);
    }

    public Map<Integer, Date> getReleaseUpgradeGracePeriodStartDates() {
        String s = this.getReleaseUpgradeGracePeriodStartDatesString();
        return this.parseVersionDates(s);
    }

    private Map<Integer, Date> parseVersionDates(String verDatesStr) {
        HashMap<Integer, Date> m = new HashMap<Integer, Date>();
        if (StringUtils.isBlank((String)verDatesStr)) {
            return m;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        String[] releases = verDatesStr.split("\\s*,\\s*");
        for (int i = 0; i < releases.length; ++i) {
            String[] parts = releases[i].split("\\s*:\\s*");
            if (parts.length != 2) {
                logger.error((Object)"Unexpected version release date format.");
                continue;
            }
            int version = 0;
            try {
                version = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Invalid version number in version release dates: " + parts[0]));
                continue;
            }
            Date releaseDate = null;
            try {
                releaseDate = dateFormat.parse(parts[1]);
            }
            catch (ParseException e) {
                logger.error((Object)("Invalid date in version release dates: " + parts[1]));
                continue;
            }
            m.put(version, releaseDate);
        }
        return m;
    }

    public int getLicenseVersionGraceMonths() {
        int months = 0;
        try {
            months = Integer.parseInt(this._props.getProperty(KEY_LICENSE_VERSION_GRACE_MONTHS, ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return months;
    }

    public int getUpdateCheckDays() {
        int days = 0;
        try {
            days = Integer.parseInt(this._props.getProperty(KEY_APP_UPDATE_CHECK_DAYS, ""));
        }
        catch (NumberFormatException e) {
            days = 90;
        }
        return days;
    }

    public String getBuildID() {
        String v = this._props.getProperty(KEY_BUILD_ID);
        if (StringUtils.isBlank((String)v)) {
            v = "?";
        }
        return v;
    }

    public String getCacheSerial() {
        if (this._developmentMode) {
            return String.valueOf(System.currentTimeMillis());
        }
        return this.getBuildID() + this.getApplicationBrand();
    }

    public String getBuildDateString() {
        String v = this._props.getProperty(KEY_BUILD_DATE);
        if (StringUtils.isBlank((String)v)) {
            v = "?";
        }
        return v;
    }

    public Date getBuildDate() {
        String dateStr = this.getBuildDateString();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public String getErrorReportURL() {
        return this._props.getProperty(KEY_ERROR_REPORT_URL);
    }

    public String getSupportURL() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_URL);
    }

    public String getKnowledgeBaseURL() {
        return this.findResellerSpecificProperty(KEY_KNOWLEDGE_BASE_URL);
    }

    public String getSupportEmail() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_EMAIL);
    }

    public String getPremiumSupportEmail() {
        return this.findResellerSpecificProperty(KEY_PREMIUM_SUPPORT_EMAIL);
    }

    public String getSupportVendor() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_VENDOR);
    }

    public String getSupportNewsURL() {
        return this.findResellerSpecificProperty(KEY_SUPPORT_NEWS_URL);
    }

    public String getSupportManualURL(Locale locale) {
        return this.findResellerSpecificProperty(KEY_SUPPORT_MANUAL_URL, locale);
    }

    public String getCopyrightOwner() {
        return this._props.getProperty(KEY_COPYRIGHT_OWNER);
    }

    public String getModulesAvailableString() {
        return this._props.getProperty(KEY_MODULES);
    }

    private String findResellerSpecificProperty(String key) {
        return this.findResellerSpecificProperty(key, Locale.getDefault());
    }

    private String findResellerSpecificProperty(String key, Locale locale) {
        String value;
        if (StringUtils.isNotBlank((String)this.getResellerId()) && !this.isBlankPropertyValue(value = this._props.getProperty(key + "." + this.getResellerId()))) {
            return value;
        }
        String langCode = locale.getLanguage();
        String countryCode = locale.getCountry();
        String value2 = this._props.getProperty(key + "." + langCode + "_" + countryCode);
        if (!this.isBlankPropertyValue(value2)) {
            return value2;
        }
        value2 = this._props.getProperty(key + "." + langCode);
        if (!this.isBlankPropertyValue(value2)) {
            return value2;
        }
        value2 = this._props.getProperty(key);
        if (this.isBlankPropertyValue(value2)) {
            return "";
        }
        return value2;
    }

    private boolean isBlankPropertyValue(String value) {
        if (StringUtils.isBlank((String)value)) {
            return true;
        }
        return value.startsWith("@") && value.endsWith("@");
    }

    public String getShortVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajorVersion()).append('.');
        sb.append(this.getMinorVersion()).append('.');
        sb.append(this.getBuildID());
        return sb.toString();
    }

    public String getFullVersion() {
        return this.buildFullVersion(false);
    }

    public List<Locale> getCompleteTranslations() {
        ArrayList<Locale> l = new ArrayList<Locale>();
        l.add(Locale.ENGLISH);
        String s = this._props.getProperty(KEY_TRANSLATIONS_COMPLETE);
        l.addAll(LocaleUtils.getLocaleListFromString(s));
        return l;
    }

    public List<Locale> getPartialTranslations() {
        String s = this._props.getProperty(KEY_TRANSLATIONS_PARTIAL);
        return LocaleUtils.getLocaleListFromString(s);
    }

    private String buildFullVersion(boolean includeBuildDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajorVersion()).append('.');
        sb.append(this.getMinorVersion());
        sb.append(this.getVersionSuffix());
        sb.append(" (Build ").append(this.getBuildID());
        if (includeBuildDate) {
            sb.append(' ').append(this.getBuildDateString());
        }
        sb.append(")");
        return sb.toString();
    }

    public String getFullVersionWithPlatformInfo() {
        String fullVersion = this.buildFullVersion(false);
        StringBuilder sb = new StringBuilder(100);
        sb.append(fullVersion);
        if (this.isPaperCutBrand()) {
            sb.append(", Edition: ").append((Object)this.getApplicationEdition());
        }
        PlatformInfo pi = PlatformInfo.getPlatformInfo();
        sb.append(", Platform: ").append(pi);
        sb.append(", User: ").append(System.getProperty("user.name"));
        return sb.toString();
    }

    private int getIntProperty(String keyName) {
        try {
            return Integer.parseInt(this._props.getProperty(keyName));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getFullVersionWithBuildDate() {
        return this.buildFullVersion(true);
    }

    public boolean isDevelopmentMode() {
        return this._developmentMode;
    }
}

