/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapEvictionListener;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObjectPool<K, V> {
    private static final Log logger = LogFactory.getLog(SimpleObjectPool.class);
    final ConcurrentMap<K, V> _map;
    final Function<K, V> _computeNewValue;

    public SimpleObjectPool(Function<K, V> computeNewValue, long expireDuration, TimeUnit unit) {
        this._map = new MapMaker().expireAfterWrite(expireDuration, unit).evictionListener(new MapEvictionListener<K, V>(){

            public void onEviction(@Nullable K k, @Nullable V v) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Expiring instance: " + k + ", size: " + SimpleObjectPool.this._map.size()));
                }
            }
        }).makeMap();
        this._computeNewValue = computeNewValue;
    }

    public PoolRef acquire(K key) {
        Preconditions.checkNotNull(key, (Object)"Key cannot be null");
        Object r = this._map.remove(key);
        if (r != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Got pooled instance for: " + key + ", size: " + this._map.size()));
            }
            return new PoolRef(key, r);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("New instance for: " + key + ", size: " + this._map.size()));
        }
        r = this._computeNewValue.apply(key);
        return new PoolRef(key, r);
    }

    private void release(PoolRef ref, boolean returnToPool) {
        Preconditions.checkNotNull((Object)ref, (Object)"Cannot release null pool reference");
        if (ref.isValid()) {
            if (returnToPool) {
                this._map.put(ref._key, ref._value);
            } else {
                this._map.remove(ref._key);
            }
            ref.invalidate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)((returnToPool ? "Returned" : "Discarded") + " instance for: " + ref._key + ", size: " + this._map.size()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Instance has already been released from the pool for: " + ref._key + ", size: " + this._map.size()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PoolRef {
        private final K _key;
        private volatile V _value;

        private PoolRef(K k, V v) {
            Preconditions.checkNotNull(k, (Object)"key is null");
            Preconditions.checkNotNull(v, (Object)"value is null");
            this._key = k;
            this._value = v;
        }

        public K getKey() {
            return this._key;
        }

        public V getValue() {
            Preconditions.checkState((boolean)this.isValid(), (Object)"Trying to access released pool object");
            return this._value;
        }

        public boolean isValid() {
            return this._value != null;
        }

        private void invalidate() {
            this._value = null;
        }

        public void release() {
            SimpleObjectPool.this.release(this, true);
        }

        public void discard() {
            SimpleObjectPool.this.release(this, false);
        }

        public String toString() {
            return this._key + "=" + (this._value == null ? "(released)" : this._value);
        }
    }
}

