/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.StringDataUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.enums.Enum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes {
    private Map<String, String> _map;

    public Attributes(Map<String, String> mapOfStrings) {
        this.setMap(mapOfStrings);
    }

    public void setString(String name, String value) {
        if (StringUtils.isBlank((String)value)) {
            this._map.remove(name);
        } else {
            this._map.put(name, value);
        }
    }

    public void setLongString(String name, String value, int maxAttributeLength) {
        String key;
        int i = 0;
        int keyIndex = 0;
        int valueLength = 0;
        if (value != null) {
            valueLength = value.length();
        }
        do {
            key = name;
            if (keyIndex != 0) {
                key = key + "." + keyIndex;
            }
            this.setString(key, StringUtils.substring((String)value, (int)i, (int)(i + maxAttributeLength)));
            ++keyIndex;
        } while ((i += maxAttributeLength) < valueLength);
        key = name + "." + keyIndex;
        while (this._map.containsKey(key)) {
            this._map.remove(key);
            key = name + "." + ++keyIndex;
        }
    }

    public String getString(String name, String defaultValue) {
        if (this._map.containsKey(name)) {
            String s = this._map.get(name);
            if (s != null) {
                return s;
            }
            this._map.remove(name);
            return defaultValue;
        }
        return defaultValue;
    }

    public String getLongString(String name, String defaultValue) {
        String v;
        int keyIndex = 0;
        StringBuilder value = new StringBuilder();
        do {
            String key = name;
            if (keyIndex != 0) {
                key = key + "." + keyIndex;
            }
            if ((v = this.getString(key, null)) == null) continue;
            value.append(v);
            ++keyIndex;
        } while (v != null);
        if (StringUtils.isBlank((String)value.toString())) {
            return defaultValue;
        }
        return value.toString();
    }

    public void trimStringValue(String attribName) {
        String value = this.getString(attribName, null);
        if (value == null || value.length() == 0) {
            return;
        }
        this.setString(attribName, StringUtils.trimToEmpty((String)value));
    }

    public void setStringArray(String name, String[] values) {
        int i;
        int n = i = values == null ? 0 : values.length;
        while (StringUtils.isNotBlank((String)this._map.get(name + "." + i))) {
            this._map.remove(name + "." + i);
            ++i;
        }
        if (values != null) {
            int j = 0;
            for (String value : values) {
                if (!StringUtils.isNotBlank((String)value)) continue;
                this._map.put(name + "." + j, StringUtils.trimToEmpty((String)value));
                ++j;
            }
        }
    }

    public String[] getStringArray(String name, String[] defaultValues) {
        String value;
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (StringUtils.isNotBlank((String)(value = this._map.get(name + "." + i)))) {
            l.add(value);
            ++i;
        }
        if (l.size() == 0) {
            return defaultValues;
        }
        return l.toArray(new String[l.size()]);
    }

    public void setInteger(String name, int value) {
        this.setString(name, StringDataUtils.intToString(value));
    }

    public int getInteger(String name, int defaultValue) {
        String s = this.getString(name, null);
        return StringDataUtils.stringToInt(s, defaultValue);
    }

    public void setDouble(String name, double value) {
        this.setString(name, StringDataUtils.doubleToString(value));
    }

    public double getDouble(String name, double defaultValue) {
        String s = this.getString(name, null);
        return StringDataUtils.stringToDouble(s, defaultValue);
    }

    public void setLong(String name, long value) {
        this.setString(name, StringDataUtils.longToString(value));
    }

    public long getLong(String name, long defaultValue) {
        String s = this.getString(name, null);
        return StringDataUtils.stringToLong(s, defaultValue);
    }

    public void setBoolean(String name, boolean value) {
        this.setString(name, StringDataUtils.booleanToString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String s = this.getString(name, null);
        return StringDataUtils.stringToBoolean(s, defaultValue);
    }

    public void setDate(String name, Date value) {
        if (value == null) {
            this.setString(name, "");
        } else {
            this.setLong(name, value.getTime());
        }
    }

    public Date getDate(String name, Date defaultValue) {
        String s = this.getString(name, null);
        if (StringUtils.isBlank((String)s)) {
            return defaultValue;
        }
        try {
            return new Date(Long.parseLong(s));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void setEnum(String name, Enum value) {
        this.setString(name, StringDataUtils.enumToString(value));
    }

    public <T extends Enum> T getEnum(String name, Class<T> enumClass, T defaultValue) {
        String s = this.getString(name, null);
        return StringDataUtils.stringToEnum(s, enumClass, defaultValue);
    }

    public <T extends Enum> T getEnum(String name, T defaultValue) {
        String s = this.getString(name, null);
        return StringDataUtils.stringToEnum(s, defaultValue);
    }

    public void setEnumArray(String name, Enum[] values) {
        if (values != null && values.length > 0) {
            String[] strVals = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                strVals[i] = StringDataUtils.enumToString(values[i]);
            }
            this.setStringArray(name, strVals);
        } else {
            this.setStringArray(name, null);
        }
    }

    public Enum[] getEnumArray(String name, Class<? extends Enum> enumClass, Enum[] defaultValues) {
        String value;
        ArrayList l = new ArrayList();
        int i = 0;
        while (StringUtils.isNotBlank((String)(value = this._map.get(name + "." + i)))) {
            Object e = StringDataUtils.stringToEnum(value, enumClass, null);
            if (e != null) {
                l.add(e);
            }
            ++i;
        }
        if (l.size() == 0) {
            return defaultValues;
        }
        Enum[] result = new Enum[l.size()];
        for (int j = 0; j < l.size(); ++j) {
            result[j] = (Enum)l.get(j);
        }
        return result;
    }

    public void remove(String attributeName) {
        this._map.remove(attributeName);
    }

    public boolean exists(String attributeName) {
        return this._map.containsKey(attributeName);
    }

    public int size() {
        return this._map.size();
    }

    public void clear() {
        this._map.clear();
    }

    public Map<String, String> getMap() {
        return this._map;
    }

    public void setMap(Map<String, String> mapOfStrings) {
        if (mapOfStrings == null) {
            throw new IllegalArgumentException("mapIfStrings is null");
        }
        this._map = mapOfStrings;
    }

    public String toString() {
        return String.valueOf(this._map);
    }

    public BoundBooleanValue getBoundBooleanValue(String attributeName, boolean defaultValue) {
        return new BoundBooleanValue(attributeName, defaultValue);
    }

    public BoundLongValue getBoundLongValue(String attributeName, long defaultValue) {
        return new BoundLongValue(attributeName, defaultValue);
    }

    public BoundIntegerValue getBoundIntegerValue(String attributeName, int defaultValue) {
        return new BoundIntegerValue(attributeName, defaultValue);
    }

    public BoundStringValue getBoundStringValue(String attributeName, String defaultValue) {
        return new BoundStringValue(attributeName, defaultValue);
    }

    public <T extends Enum> BoundEnumValue<T> getBoundEnumValue(String attributeName, Class<T> enumClass, T defaultValue) {
        return new BoundEnumValue(this, attributeName, enumClass, defaultValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoundEnumValue<T extends Enum> {
        private final String _attributeName;
        private final Class<T> _enumClass;
        private final T _defaultValue;
        final /* synthetic */ Attributes this$0;

        public BoundEnumValue(String attributeName, Class<T> enumClass, T defaultValue) {
            this.this$0 = var1_1;
            this._attributeName = attributeName;
            this._enumClass = enumClass;
            this._defaultValue = defaultValue;
        }

        public T getValue() {
            return this.this$0.getEnum(this._attributeName, this._enumClass, this._defaultValue);
        }

        public void setValue(T value) {
            this.this$0.setEnum(this._attributeName, (Enum)value);
        }
    }

    public class BoundStringValue {
        private String _attributeName;
        private String _defaultValue;

        public BoundStringValue(String attributeName, String defaultValue) {
            this._attributeName = attributeName;
            this._defaultValue = defaultValue;
        }

        public String getValue() {
            return Attributes.this.getString(this._attributeName, this._defaultValue);
        }

        public void setValue(String value) {
            Attributes.this.setString(this._attributeName, value);
        }
    }

    public class BoundLongValue {
        private String _attributeName;
        private long _defaultValue;

        public BoundLongValue(String attributeName, long defaultValue) {
            this._attributeName = attributeName;
            this._defaultValue = defaultValue;
        }

        public long getValue() {
            return Attributes.this.getLong(this._attributeName, this._defaultValue);
        }

        public void setValue(int value) {
            Attributes.this.setInteger(this._attributeName, value);
        }
    }

    public class BoundIntegerValue {
        private String _attributeName;
        private int _defaultValue;

        public BoundIntegerValue(String attributeName, int defaultValue) {
            this._attributeName = attributeName;
            this._defaultValue = defaultValue;
        }

        public int getValue() {
            return Attributes.this.getInteger(this._attributeName, this._defaultValue);
        }

        public void setValue(int value) {
            Attributes.this.setInteger(this._attributeName, value);
        }
    }

    public class BoundBooleanValue {
        private String _attributeName;
        private boolean _defaultValue;

        public BoundBooleanValue(String attributeName, boolean defaultValue) {
            this._attributeName = attributeName;
            this._defaultValue = defaultValue;
        }

        public boolean getValue() {
            return Attributes.this.getBoolean(this._attributeName, this._defaultValue);
        }

        public void setValue(boolean value) {
            Attributes.this.setBoolean(this._attributeName, value);
        }
    }
}

