/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.BrowserLauncherRunner;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BrowserLinkUtils {
    private static final Log logger = LogFactory.getLog(BrowserLinkUtils.class);

    private BrowserLinkUtils() {
    }

    public static void openBrowser(String url) {
        if (BrowserLinkUtils.tryOpenBrowserWithJavaDesktop(url)) {
            return;
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            BrowserLinkUtils.openBrowserUsingBL2(url);
        } else if (SystemUtils.IS_OS_WINDOWS_ME || SystemUtils.IS_OS_WINDOWS_98 || SystemUtils.IS_OS_WINDOWS_95) {
            BrowserLinkUtils.openBrowserUsingBL2(url);
        } else {
            BrowserLinkUtils.openBrowserUsingUrlDLL(url);
        }
    }

    private static boolean tryOpenBrowserWithJavaDesktop(String url) {
        Object desktop = null;
        Method browseMethod = null;
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Method isSupportedMethod = desktopClass.getMethod("isDesktopSupported", new Class[0]);
            if (!((Boolean)isSupportedMethod.invoke(null, (Object[])null)).booleanValue()) {
                logger.debug((Object)"Java 'desktop' not supported.");
                return false;
            }
            Method getDesktopMethod = desktopClass.getMethod("getDesktop", new Class[0]);
            desktop = getDesktopMethod.invoke(null, (Object[])null);
            browseMethod = desktopClass.getMethod("browse", URI.class);
        }
        catch (Exception e) {
            logger.debug((Object)"Java 'desktop' support not available.", (Throwable)e);
            return false;
        }
        try {
            URI uri = new URI(url);
            browseMethod.invoke(desktop, uri);
            return true;
        }
        catch (Exception e) {
            logger.debug((Object)"Cannot open URL with Java 'desktop'.", (Throwable)e);
            return false;
        }
    }

    private static void openBrowserUsingBL2(String url) {
        try {
            BrowserLauncher launcher = new BrowserLauncher(null);
            BrowserLauncherRunner runner = new BrowserLauncherRunner(launcher, url, null);
            Thread launcherThread = new Thread((Runnable)runner);
            launcherThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void openBrowserUsingUrlDLL(final String url) {
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        launcherThread.start();
    }
}

