/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringDataUtils {
    private static final Log logger = LogFactory.getLog(StringDataUtils.class);

    private StringDataUtils() {
    }

    public static String intToString(int value) {
        return String.valueOf(value);
    }

    public static int stringToInt(String value, int defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String longToString(long value) {
        return String.valueOf(value);
    }

    public static long stringToLong(String value, long defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String listOfLongsToString(List<Long> values) {
        if (values == null || values.size() == 0) {
            return "";
        }
        return StringUtils.join(values.iterator(), (char)',');
    }

    public static List<Long> stringToListOfLongs(String value) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (value == null || StringUtils.isBlank((String)value)) {
            return list;
        }
        for (String l : value.split("\\s*,\\s*")) {
            if (StringUtils.isBlank((String)l)) continue;
            try {
                list.add(Long.valueOf(StringUtils.trimToEmpty((String)l)));
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Encountered bad value in a list of longs: " + l));
            }
        }
        return list;
    }

    public static String doubleToString(double value) {
        return String.valueOf(value);
    }

    public static double stringToDouble(String value, double defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Date stringToDate(String value, Date defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'H:m:s", Locale.US);
            return format.parse(value);
        }
        catch (ParseException pe) {
            logger.error((Object)("Error parsing date system property: " + value), (Throwable)pe);
            return defaultValue;
        }
    }

    public static String dateToString(Date value) {
        if (value == null) {
            return "";
        }
        return DateFormatUtils.ISO_DATETIME_FORMAT.format(value);
    }

    public static boolean stringToBoolean(String value, boolean defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trim((String)value)))) {
            return defaultValue;
        }
        char c = value.toUpperCase().charAt(0);
        return c == 'Y' || c == 'T' || c == '1' | "on".equalsIgnoreCase(value);
    }

    public static String booleanToString(boolean value) {
        return value ? "Y" : "N";
    }

    public static String enumToString(Enum value) {
        if (value == null) {
            return "";
        }
        return value.getName();
    }

    public static <T extends Enum> T stringToEnum(String value, T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue cannot be null. To use null default use stringToEnum that takes a class argument.");
        }
        return (T)StringDataUtils.stringToEnum(value, defaultValue.getClass(), defaultValue);
    }

    public static <T extends Enum> T stringToEnum(String value, Class<T> enumClass, T defaultValue) {
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("type should represent an apache.commons.lang.Enum super class");
        }
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        Object r = null;
        try {
            r = (Enum)enumClass.getDeclaredMethod("getEnum", String.class).invoke(null, value);
        }
        catch (Exception e) {
            logger.debug((Object)("Could not create a new Enum object from give type with value: " + value));
            return defaultValue;
        }
        if (r == null) {
            r = defaultValue;
        }
        return (T)r;
    }

    public static String sanitiseString(String s) {
        if (s == null) {
            return null;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = s.charAt(i);
            if ((ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') && (ch < '\ud800' || ch >= '\ue000')) continue;
            return StringDataUtils.sanitiseStringInternal(s);
        }
        return s;
    }

    private static String sanitiseStringInternal(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = s.charAt(i);
            if (ch < ' ' && ch != '\n' && ch != '\r' && ch != '\t' || ch >= '\ud800' && ch < '\ue000') continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

