/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthDialog;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AuthHandler
implements ClientController.AuthenticationEventListener {
    private static final Logger logger = Logger.getLogger(AuthHandler.class);
    private ServerConnection _serverConnection;
    private UserClientConfig _config;
    private UserClientFrame _userClientFrame;

    public AuthHandler(UserClientFrame userClientFrame, ServerConnection serverConnection, UserClientConfig clientConfig) {
        this._serverConnection = serverConnection;
        this._config = clientConfig;
        this._userClientFrame = userClientFrame;
    }

    public void newAuthenticationRequest() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AuthHandler.this.doAuthRequest();
                }
            });
        }
        catch (Throwable t) {
            logger.error((Object)("Error displaying auth dialog. " + t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthRequest() {
        try {
            logger.debug((Object)"Processing an authentication request");
            String savedAuthCookie = ClientConfigFile.loadUserAuthCookie();
            if (StringUtils.isNotBlank((String)savedAuthCookie)) {
                ClientAuthResponse r = this._serverConnection.authenticateUserWithCookie(savedAuthCookie);
                if (r.isSuccess()) {
                    logger.debug((Object)"Successfully authenticated with cookie.");
                    this._config.setDisplayUserName(r.getRealName());
                    this._config.setCurrentlyAuthenticated(true);
                    this._userClientFrame.updateDisplay();
                    return;
                }
                logger.debug((Object)("Failed to authenticate with cookie. Clear cookie and display auth dialog. Error: " + r.getErrorMessage()));
                ClientConfigFile.deleteUserAuthCookie();
            }
            this._userClientFrame.setPopupDialogIsDisplayed(true);
            AuthDialog d = new AuthDialog(this._userClientFrame, this._config, this._serverConnection);
            DialogUtils.setAlwaysOnTop((Window)d, (boolean)true);
            d.setVisible(true);
            DialogUtils.setAlwaysOnTop((Window)d, (boolean)false);
            d.dispose();
            Object var2_3 = null;
        }
        catch (Throwable t) {
            logger.error((Object)("Error displaying auth dialog. " + t.getMessage()), t);
        }
        finally {
            this._userClientFrame.setPopupDialogIsDisplayed(false);
        }
    }

    public void authenticationExpired() {
        try {
            this._config.setDisplayUserName(this._config.getUserName());
            this._config.setCurrentlyAuthenticated(false);
            this._config.setLastPopupSelection(null);
            this._userClientFrame.updateDisplay();
        }
        catch (Exception e) {
            logger.error((Object)"Error processing expire auth request", (Throwable)e);
        }
    }
}

