/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.util.ApplicationInfo;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJQuitHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MacUtils {
    private static final String CLIENT_APP_NAME = "PCClient";
    private static final Log logger = LogFactory.getLog(MacUtils.class);

    private MacUtils() {
    }

    public static void registerQuitHandler(final UserClientFrame userClientFrame) {
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)new MRJQuitHandler(){

            public void handleQuit() {
                userClientFrame.shutdown();
            }
        });
    }

    public static boolean growlNotify(String message) {
        try {
            logger.debug((Object)"trying growl ...");
            Process growlNotify = Runtime.getRuntime().exec("./growlnotify --image client-icon.icns  -n PCClient " + ApplicationInfo.getInstance().getApplicationName());
            OutputStreamWriter output = new OutputStreamWriter(growlNotify.getOutputStream(), "UTF-8");
            output.write(message);
            ((Writer)output).close();
            InputStreamReader error = new InputStreamReader(growlNotify.getErrorStream(), "UTF-8");
            int bytes = ((Reader)error).read();
            ((Reader)error).close();
            logger.debug((Object)("growlnotify stderr returned: " + bytes));
            int exitValue = growlNotify.waitFor();
            logger.debug((Object)("growlnotify exit value: " + exitValue));
            return exitValue == 0 && bytes < 0;
        }
        catch (IOException e) {
            logger.info((Object)("Error running growlnotify: " + e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)"growlNotify waitFor interrupted", (Throwable)e);
        }
        return false;
    }
}

