/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ClientAccountCache;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.PrintJobDetailsPanel;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.client.uit.accounts.AccountList;
import biz.papercut.pcng.client.uit.accounts.PreferredList;
import biz.papercut.pcng.client.uit.accounts.RecentList;
import biz.papercut.pcng.common.AccountCommentOption;
import biz.papercut.pcng.common.AccountInvoiceOption;
import biz.papercut.pcng.common.ChargeRate;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientJobUpdateResponse;
import biz.papercut.pcng.common.ClientPopupInfo;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.ClientPrintPopupConfig;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.NumberUtils;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.EnhancedTextField;
import biz.papercut.pcng.util.swing.SwingWorker;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdvancedAccountDialog
extends JDialog {
    private static final Log logger = LogFactory.getLog(AdvancedAccountDialog.class);
    private static final int ACCOUNT_LIST_IDX = 0;
    private static final int PREF_LIST_IDX = 1;
    private static final int RECENT_LIST_IDX = 2;
    private static final int COMMENT_MAX_LENGTH = 255;
    private static final long PERSONAL_ACCOUNT_ID = -1L;
    private static int s_lastSelectedTab = 0;
    private static String s_lastComment = "";
    private static Boolean s_rememberLastComment = false;
    private ServerConnection _serverConnection;
    private ClientPrintJob _printJob;
    private ClientPrintPopupConfig _printJobConfig;
    private UserClientConfig _clientConfig;
    private AccountIdListModel _preferredAccounts;
    private boolean _preferredAccountsHasChanged = false;
    private AccountList _accountList;
    private PreferredList _prefList;
    private RecentList _recentList;
    private JButton _okButton;
    private JButton _cancelButton;
    private JCheckBox _applyToAllInQueue;
    private JComboBox _chargeRateComboBox;
    private JTextField _commentTextField;
    private PrintJobDetailsPanel _printJobDetailsPanel;
    private JTabbedPane _tabbedPane;
    private JCheckBox _invoiceOption;
    private JCheckBox _rememberCommentCheckbox;
    private DialogBannerPanel _dialogBannerPanel;
    private int _jobsInQueue = 1;
    private boolean _userMustSelectChargeRate = false;
    private final Timer _updateJobInfoTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            AdvancedAccountDialog.this.fetchUpdatedJobInfo();
        }
    });
    private final Timer _updateJobCountTimer = new Timer(2000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            AdvancedAccountDialog.this.fetchUpdatedJobCount();
        }
    });

    public AdvancedAccountDialog(JFrame owner, UserClientConfig clientConfig, ServerConnection serverConnection, ClientPrintJob printJob, ClientPrintPopupConfig printJobConfig) {
        super((Frame)owner, true);
        DialogUtils.setAlwaysOnTop((Window)this, (boolean)true);
        this.toFront();
        this._serverConnection = serverConnection;
        this._printJob = printJob;
        this._printJobConfig = printJobConfig;
        this._clientConfig = clientConfig;
        boolean showCode = clientConfig.getServerGlobalConfig().isPinVisible();
        this._accountList = new AccountList(showCode);
        this._prefList = new PreferredList(showCode);
        this._recentList = new RecentList(showCode);
        this._commentTextField = new EnhancedTextField(255);
        this._tabbedPane = new JTabbedPane();
        this._invoiceOption = new JCheckBox(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.SHOW_ON_INVOICE", (String[])new String[0]));
        this._chargeRateComboBox = new JComboBox();
        this._rememberCommentCheckbox = this.getRememberCommentCheckbox();
        this._printJobDetailsPanel = new PrintJobDetailsPanel();
        SelectionListener selectionListener = new SelectionListener();
        this._accountList.addListSelectionListener(selectionListener);
        this._prefList.addListSelectionListener(selectionListener);
        this._recentList.addListSelectionListener(selectionListener);
        this._userMustSelectChargeRate = printJobConfig.isUserMustSelectChargeRate();
        this.layoutComponents();
        this._tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                s_lastSelectedTab = AdvancedAccountDialog.this._tabbedPane.getSelectedIndex();
                AdvancedAccountDialog.this.accountSelectionChange();
            }
        });
        this.getRootPane().setDefaultButton(this.getOkButton(this));
        this.setTitle(Messages.getString(this.getClass(), (String)"SelectAccount.title", (String[])new String[0]));
        this.doLayout();
        this.pack();
        final int minWidth = (int)this.getSize().getWidth();
        final int minHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AdvancedAccountDialog.this.setSize(new Dimension(Math.max(minWidth, AdvancedAccountDialog.this.getWidth()), Math.max(minHeight, AdvancedAccountDialog.this.getHeight())));
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AdvancedAccountDialog.this.cancelButtonPressed();
            }
        });
        this.setSize((int)((double)minWidth * 1.2), (int)((double)minHeight * 1.4));
        this.setLocationRelativeTo(null);
        if (s_rememberLastComment.booleanValue()) {
            this._commentTextField.setText(s_lastComment);
        }
        this._tabbedPane.setSelectedIndex(s_lastSelectedTab);
        if (this._tabbedPane.getSelectedIndex() == 0) {
            this._accountList.requestFocusInWindow();
        } else {
            this._commentTextField.requestFocusInWindow();
            this._commentTextField.selectAll();
        }
        this._printJobDetailsPanel.displayJobDetails(printJob);
        this.loadData();
        this._updateJobCountTimer.start();
        if (this._printJob.isPreNotification()) {
            this._updateJobInfoTimer.start();
        }
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this);
        DialogUtils.forceRepaintAfterOpened((Window)this);
    }

    private void layoutComponents() {
        this._accountList.setOpaque(false);
        this._tabbedPane.add(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.ALL_ACCOUNTS", (String[])new String[0]), this._accountList);
        this._prefList.setOpaque(false);
        this._tabbedPane.add(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.PREFERRED_LIST", (String[])new String[0]), this._prefList);
        this._recentList.setOpaque(false);
        this._tabbedPane.add(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.RECENT", (String[])new String[0]), this._recentList);
        JPanel accountPanel = new JPanel();
        FormLayout layout = new FormLayout("pref, 2dlu, pref, 2dlu, pref:grow, pref", "pref, 2dlu, pref, 2dlu, pref:grow");
        PanelBuilder builder = new PanelBuilder(layout, accountPanel);
        CellConstraints cc = new CellConstraints();
        builder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        builder.addLabel(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.COMMENT", (String[])new String[0]), cc.xy(1, 1));
        builder.add((Component)this._commentTextField, cc.xyw(3, 1, 3));
        builder.add((Component)this.getRememberCommentCheckbox(), cc.xy(6, 1));
        builder.addLabel(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.ADJUSTMENT", (String[])new String[0]), cc.xy(1, 3));
        builder.add((Component)this._chargeRateComboBox, cc.xy(3, 3));
        builder.add((Component)this._invoiceOption, cc.xy(6, 3));
        builder.add((Component)this._tabbedPane, cc.xyw(1, 5, 6, CellConstraints.FILL, CellConstraints.FILL));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this._printJobDetailsPanel, "North");
        mainPanel.add((Component)accountPanel, "Center");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.getDialogBannerPanel(), "North");
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.add((Component)this.getButtonPanel(), "South");
        this.setContentPane(contentPanel);
    }

    private JPanel getButtonPanel() {
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.gridx = 0;
        gridBagConstraints28.weightx = 1.0;
        gridBagConstraints28.anchor = 17;
        gridBagConstraints28.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints28.gridy = 0;
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.insets = new Insets(5, 3, 5, 5);
        gridBagConstraints27.gridy = 0;
        gridBagConstraints27.gridx = 2;
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(5, 5, 5, 2);
        gridBagConstraints26.gridy = 0;
        gridBagConstraints26.gridx = 1;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)this.getOkButton(this), gridBagConstraints26);
        buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints27);
        buttonPanel.add((Component)this.getApplyToAllInQueue(), gridBagConstraints28);
        return buttonPanel;
    }

    private DialogBannerPanel getDialogBannerPanel() {
        if (this._dialogBannerPanel == null) {
            this._dialogBannerPanel = UserClientUtils.getStandardDialogBanner(Messages.getString(this.getClass(), (String)"SelectAccount.title", (String[])new String[0]), Messages.getString(this.getClass(), (String)"SelectAccount.description", (String[])new String[0]), this._clientConfig.getServerGlobalConfig());
        }
        return this._dialogBannerPanel;
    }

    private JButton getOkButton(JDialog parent) {
        if (this._okButton == null) {
            this._okButton = new JButton();
            this._okButton.setText(Messages.getString(this.getClass(), (String)"SelectAccount.print", (String[])new String[0]));
            this._okButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    try {
                        AdvancedAccountDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        AdvancedAccountDialog.this.okButtonPressed();
                    }
                    finally {
                        AdvancedAccountDialog.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }
        return this._okButton;
    }

    private JButton getCancelButton() {
        if (this._cancelButton == null) {
            this._cancelButton = new JButton();
            this._cancelButton.setText(Messages.getString(this.getClass(), (String)"SelectAccount.cancel", (String[])new String[0]));
            this._cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AdvancedAccountDialog.this.cancelButtonPressed();
                }
            });
        }
        return this._cancelButton;
    }

    private JCheckBox getRememberCommentCheckbox() {
        if (this._rememberCommentCheckbox == null) {
            this._rememberCommentCheckbox = new JCheckBox();
            this._rememberCommentCheckbox.setText(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.REMEMBER", (String[])new String[0]));
            this._rememberCommentCheckbox.setSelected(s_rememberLastComment);
            this._rememberCommentCheckbox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    s_rememberLastComment = AdvancedAccountDialog.this._rememberCommentCheckbox.isSelected();
                }
            });
        }
        return this._rememberCommentCheckbox;
    }

    private JCheckBox getApplyToAllInQueue() {
        if (this._applyToAllInQueue == null) {
            this._applyToAllInQueue = new JCheckBox();
            this._applyToAllInQueue.setText(Messages.getString(this.getClass(), (String)"SelectAccount.apply-to-all-in-queue", (String[])new String[]{"1"}));
        }
        return this._applyToAllInQueue;
    }

    protected void okButtonPressed() {
        boolean applyToAll;
        ClientJobUpdateResponse status;
        ClientAccount selectedAccount = this.getSelectedAccount();
        if (selectedAccount == null || selectedAccount.isDisabled()) {
            this.displayErrorDialog(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.NO_ACCOUNT_SELECTED", (String[])new String[0]));
            return;
        }
        if (selectedAccount.getComments().equals((Object)AccountCommentOption.COMMENT_REQUIRED) && StringUtils.isBlank((String)this._commentTextField.getText())) {
            this.displayErrorDialog(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.COMMENT_REQUIRED", (String[])new String[0]));
            this._commentTextField.requestFocusInWindow();
            return;
        }
        this.savePreferredAccounts();
        ClientPopupInfo popupInfo = new ClientPopupInfo();
        if (!this.getSelectedAccount().getComments().equals((Object)AccountCommentOption.NO_COMMENT)) {
            popupInfo.setComment(StringUtils.left((String)this._commentTextField.getText(), (int)255));
            popupInfo.setComment(StringUtils.trimToEmpty((String)popupInfo.getComment()));
        }
        popupInfo.setInvoice(Boolean.valueOf(this._invoiceOption.isSelected()));
        long accountID = this.getSelectedAccount().getAccountId();
        if (accountID == -1L) {
            popupInfo.setChargeToAccountType(ChargeToAccountType.PersonalAccount);
            accountID = 0L;
        } else {
            popupInfo.setChargeToAccountType(ChargeToAccountType.AccountFromList);
        }
        popupInfo.setAccountId(accountID);
        if (this._userMustSelectChargeRate && this._chargeRateComboBox.getSelectedIndex() == 0) {
            this.displayErrorDialog(Messages.getString(this.getClass(), (String)"AdvancedAccountDialog.ADJUSTMENT_REQUIRED", (String[])new String[0]));
            return;
        }
        ChargeRate cr = (ChargeRate)this._chargeRateComboBox.getSelectedItem();
        if (cr != null) {
            ArrayList<ChargeRate> rates = new ArrayList<ChargeRate>();
            rates.add(cr);
            popupInfo.setChargeRates(rates);
        }
        if ((status = (applyToAll = this._applyToAllInQueue.isSelected()) ? this._serverConnection.updateAllPendingPrintJobs(this._printJob, false, popupInfo) : this._serverConnection.updatePendingPrintJob(this._printJob, false, popupInfo)).isSuccess()) {
            this.closeAccountDialog();
        } else {
            this.displayErrorDialog(status.getErrorMessage());
            if (!status.isAllowRetry()) {
                this.closeAccountDialog();
            }
        }
        s_lastComment = this._rememberCommentCheckbox.isSelected() ? this._commentTextField.getText() : "";
    }

    private void displayErrorDialog(String msg) {
        DialogUtils.showInformationMessageDialog((Component)this, (String)Messages.getString(this.getClass(), (String)"SelectAccount.error", (String[])new String[0]), (String)msg);
    }

    private void savePreferredAccounts() {
        if (this._preferredAccountsHasChanged) {
            logger.debug((Object)"Preferred account has changed so submitting this to the server");
            this._serverConnection.setUsersPreferredAccounts(this._printJob, this._preferredAccounts.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelButtonPressed() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.savePreferredAccounts();
            boolean applyToAll = this._applyToAllInQueue.isSelected();
            this._serverConnection.cancelPendingPrintJob(this._printJob, applyToAll);
            this.closeAccountDialog();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void closeAccountDialog() {
        this._updateJobCountTimer.stop();
        this._updateJobInfoTimer.stop();
        this.setVisible(false);
    }

    protected void accountSelectionChange() {
        ClientAccount ca = this.getSelectedAccount();
        if (ca != null) {
            if (ca.isDisabled()) {
                this._commentTextField.setEnabled(false);
                this._invoiceOption.setEnabled(false);
                this._invoiceOption.setSelected(false);
            } else {
                this._commentTextField.setEnabled(!ca.getComments().equals((Object)AccountCommentOption.NO_COMMENT));
                AccountInvoiceOption invoiceOption = ca.getInvoicing();
                if (invoiceOption.equals((Object)AccountInvoiceOption.NEVER_INVOICE)) {
                    this._invoiceOption.setEnabled(false);
                    this._invoiceOption.setSelected(false);
                } else if (invoiceOption.equals((Object)AccountInvoiceOption.ALWAYS_INVOICE)) {
                    this._invoiceOption.setEnabled(false);
                    this._invoiceOption.setSelected(true);
                } else if (invoiceOption.equals((Object)AccountInvoiceOption.USER_CHOICE_ON)) {
                    this._invoiceOption.setEnabled(true);
                    this._invoiceOption.setSelected(true);
                } else if (invoiceOption.equals((Object)AccountInvoiceOption.USER_CHOICE_OFF)) {
                    this._invoiceOption.setEnabled(true);
                    this._invoiceOption.setSelected(false);
                }
            }
        }
    }

    private ClientAccount getSelectedAccount() {
        ClientAccount ca = null;
        if (this._tabbedPane.getSelectedIndex() == 0) {
            ca = this._accountList.getSelectedAccount();
        } else if (this._tabbedPane.getSelectedIndex() == 1) {
            ca = this._prefList.getSelectedAccount();
        } else if (this._tabbedPane.getSelectedIndex() == 2) {
            ca = this._recentList.getSelectedAccount();
        }
        return ca;
    }

    public boolean selectionAppliedToAllJobs() {
        return this._applyToAllInQueue.isSelected();
    }

    private void loadData() {
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private volatile List<ClientAccount> _accounts;
            private volatile List<Long> _recentAccounts;

            public Object construct() {
                ClientAccountCache cac = ClientAccountCache.getInstance();
                this._accounts = new ArrayList<ClientAccount>(cac.getUserAccounts(AdvancedAccountDialog.this._printJob, AdvancedAccountDialog.this._clientConfig.getDisplayUserName(), AdvancedAccountDialog.this));
                if (AdvancedAccountDialog.this._printJobConfig.isCanChargeToPersonalAccount()) {
                    ClientAccount personal = new ClientAccount(-1L);
                    personal.setParentName(Messages.getString(((Object)((Object)this)).getClass(), (String)"AdvancedAccountDialog.PERSONAL_ACCOUNT", (String[])new String[0]));
                    personal.setComments(AccountCommentOption.COMMENT_OPTIONAL);
                    personal.setInvoicing(AccountInvoiceOption.NEVER_INVOICE);
                    this._accounts.add(personal);
                }
                String prefAcc = AdvancedAccountDialog.this._serverConnection.getUsersPreferredAccounts(AdvancedAccountDialog.this._printJob);
                AdvancedAccountDialog.this._preferredAccounts = new AccountIdListModel(prefAcc);
                AdvancedAccountDialog.this._preferredAccounts.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        AdvancedAccountDialog.this._preferredAccountsHasChanged = true;
                    }
                });
                String recentAccountsList = AdvancedAccountDialog.this._serverConnection.getUsersRecentAccounts(AdvancedAccountDialog.this._printJob);
                this._recentAccounts = NumberUtils.splitStringToLongList((String)recentAccountsList, (char)',');
                return null;
            }

            public void finished() {
                AdvancedAccountDialog.this.loadChargeRates();
                AdvancedAccountDialog.this._accountList.loadData(this._accounts, AdvancedAccountDialog.this._preferredAccounts);
                if (AdvancedAccountDialog.this._clientConfig.getDefaultSelectedOption() != null) {
                    if (ChargeToAccountType.PersonalAccount.equals((Object)AdvancedAccountDialog.this._clientConfig.getDefaultSelectedOption())) {
                        AdvancedAccountDialog.this._accountList.selectPersonalAccount();
                    } else if (ChargeToAccountType.AccountFromList.equals((Object)AdvancedAccountDialog.this._clientConfig.getDefaultSelectedOption())) {
                        AdvancedAccountDialog.this._accountList.selectAccountByName(AdvancedAccountDialog.this._clientConfig.getDefaultSelectedAccount());
                    }
                } else if (StringUtils.isNotBlank((String)AdvancedAccountDialog.this._clientConfig.getServerUserConfig().getDefaultSharedAccountName())) {
                    AdvancedAccountDialog.this._accountList.selectAccountByName(AdvancedAccountDialog.this._clientConfig.getServerUserConfig().getDefaultSharedAccountName());
                }
                AdvancedAccountDialog.this._prefList.loadData(this._accounts, AdvancedAccountDialog.this._preferredAccounts);
                AdvancedAccountDialog.this._recentList.loadData(this._accounts, this._recentAccounts);
                AdvancedAccountDialog.this.accountSelectionChange();
            }
        };
        worker.start();
    }

    private void loadChargeRates() {
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private volatile List<ChargeRate> _chargeRates;

            public Object construct() {
                this._chargeRates = AdvancedAccountDialog.this._serverConnection.getChargeRates(AdvancedAccountDialog.this._printJob);
                return null;
            }

            public void finished() {
                if (this._chargeRates.size() == 0) {
                    ChargeRate cr = ChargeRate.getDefaultChargeRate();
                    AdvancedAccountDialog.this._chargeRateComboBox.addItem(cr);
                    AdvancedAccountDialog.this._userMustSelectChargeRate = false;
                } else {
                    if (AdvancedAccountDialog.this._userMustSelectChargeRate) {
                        AdvancedAccountDialog.this._chargeRateComboBox.addItem(Messages.getString(((Object)((Object)this)).getClass(), (String)"AdvancedAccountDialog.SELECT_CHARGE_RATE", (String[])new String[0]));
                    }
                    for (ChargeRate cr : this._chargeRates) {
                        AdvancedAccountDialog.this._chargeRateComboBox.addItem(cr);
                    }
                }
            }
        };
        worker.start();
    }

    protected void fetchUpdatedJobCount() {
        this._updateJobCountTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                int newJobCount = AdvancedAccountDialog.this._serverConnection.getPendingPrintJobCount();
                if (newJobCount != AdvancedAccountDialog.this._jobsInQueue) {
                    AdvancedAccountDialog.this._updateJobCountTimer.setDelay(4000);
                    AdvancedAccountDialog.this._updateJobCountTimer.setInitialDelay(4000);
                    AdvancedAccountDialog.this._jobsInQueue = newJobCount;
                }
                return null;
            }

            public void finished() {
                String jobs = String.valueOf(AdvancedAccountDialog.this._jobsInQueue);
                AdvancedAccountDialog.this._applyToAllInQueue.setText(Messages.getString(((Object)((Object)this)).getClass(), (String)"SelectAccount.apply-to-all-in-queue", (String[])new String[]{jobs}));
                AdvancedAccountDialog.this._updateJobCountTimer.start();
                int newDelay = Math.min(AdvancedAccountDialog.this._updateJobCountTimer.getDelay() + 2000, 20000);
                AdvancedAccountDialog.this._updateJobCountTimer.setDelay(newDelay);
                AdvancedAccountDialog.this._updateJobCountTimer.setInitialDelay(newDelay);
            }
        };
        worker.start();
    }

    private void fetchUpdatedJobInfo() {
        this._updateJobInfoTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                AdvancedAccountDialog.this._serverConnection.getUpdatedPrintJobInfo(AdvancedAccountDialog.this._printJob);
                return null;
            }

            public void finished() {
                AdvancedAccountDialog.this._printJobDetailsPanel.displayJobDetails(AdvancedAccountDialog.this._printJob);
                if (AdvancedAccountDialog.this._printJob.isPreNotification()) {
                    int newDelay = Math.min(AdvancedAccountDialog.this._updateJobInfoTimer.getDelay() + 1000, 10000);
                    AdvancedAccountDialog.this._updateJobInfoTimer.setInitialDelay(newDelay);
                    AdvancedAccountDialog.this._updateJobInfoTimer.setDelay(newDelay);
                    AdvancedAccountDialog.this._updateJobInfoTimer.start();
                }
            }
        };
        worker.start();
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                AdvancedAccountDialog.this.accountSelectionChange();
            }
        }
    }
}

