/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.AbstractSequentialList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.impl.AnnotationArray;
import net.sf.retrotranslator.runtime.impl.AnnotationHandler;
import net.sf.retrotranslator.runtime.impl.AnnotationValue;
import net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime.impl.ClassTypeElement;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.runtime.impl.EnumValue;
import net.sf.retrotranslator.runtime.impl.GenericArrayTypeImpl;
import net.sf.retrotranslator.runtime.impl.LazyList;
import net.sf.retrotranslator.runtime.impl.LazyValue;
import net.sf.retrotranslator.runtime.impl.MethodDescriptor;
import net.sf.retrotranslator.runtime.impl.ParameterizedTypeImpl;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.impl.TypeArgument;
import net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import net.sf.retrotranslator.runtime.impl.WildcardTypeImpl;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang.TypeNotPresentException_;
import net.sf.retrotranslator.runtime.java.lang.annotation.AnnotationTypeMismatchException_;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import net.sf.retrotranslator.runtime.java.lang.annotation.IncompleteAnnotationException_;
import net.sf.retrotranslator.runtime.java.lang.reflect.TypeVariable_;
import net.sf.retrotranslator.runtime.java.lang.reflect.Type_;

public abstract class AnnotatedElementDescriptor
extends EmptyVisitor {
    private static final Annotation_[] EMPTY = new Annotation_[0];
    protected int access;
    private LazyList declaredAnnotations = new LazyList(){

        protected Annotation_ resolve(AnnotationValue annotationValue) {
            return AnnotatedElementDescriptor.this.createAnnotation(annotationValue);
        }

        protected Annotation_[] newArray(int n) {
            return new Annotation_[n];
        }
    };
    private LazyValue annotations = new LazyValue(this.declaredAnnotations){

        protected Annotation_[] resolve(LazyList lazyList) {
            return AnnotatedElementDescriptor.this.createAnnotations((Annotation_[])lazyList.getLive());
        }
    };

    public boolean isAccess(int n) {
        return (this.access & n) != 0;
    }

    public boolean isAnnotationPresent(Class clazz) {
        Annotation_[] annotation_Array = (Annotation_[])this.annotations.get();
        int n = annotation_Array.length;
        for (int i = 0; i < n; ++i) {
            Annotation_ annotation_ = annotation_Array[i];
            if (!clazz.isInstance(annotation_)) continue;
            return true;
        }
        return false;
    }

    public Annotation_ getAnnotation(Class clazz) {
        Annotation_[] annotation_Array = (Annotation_[])this.annotations.get();
        int n = annotation_Array.length;
        for (int i = 0; i < n; ++i) {
            Annotation_ annotation_ = annotation_Array[i];
            if (!clazz.isInstance(annotation_)) continue;
            return annotation_;
        }
        return null;
    }

    public Annotation_[] getAnnotations() {
        Annotation_[] annotation_Array = (Annotation_[])this.annotations.get();
        return annotation_Array.length == 0 ? annotation_Array : (Annotation_[])annotation_Array.clone();
    }

    public Annotation_[] getDeclaredAnnotations() {
        return (Annotation_[])this.declaredAnnotations.getClone();
    }

    public abstract ClassDescriptor getClassDescriptor();

    protected abstract TypeVariable_ findTypeVariable(String var1);

    protected abstract Annotation_[] createAnnotations(Annotation_[] var1);

    protected Annotation_[] createAnnotations(List list) {
        if (list == null) {
            return EMPTY;
        }
        Annotation_[] annotation_Array = new Annotation_[list.size()];
        for (int i = 0; i < annotation_Array.length; ++i) {
            annotation_Array[i] = this.createAnnotation((AnnotationValue)list.get(i));
        }
        return annotation_Array;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (!bl) {
            return null;
        }
        AnnotationValue annotationValue = new AnnotationValue(string);
        this.declaredAnnotations.add(annotationValue);
        return annotationValue;
    }

    private ClassLoader getClassLoader() {
        return this.getClassDescriptor().getTarget().getClassLoader();
    }

    protected Class getClassByInternalName(String string) {
        string = string.replace('/', '.');
        try {
            return Class.forName(string, false, this.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException_(string, classNotFoundException);
        }
    }

    protected Class getClassByType(Type type) {
        Class clazz = RuntimeTools.getBaseClass(type);
        if (clazz != null) {
            return clazz;
        }
        return this.getClassByInternalName(type.getSort() == 9 ? type.getDescriptor() : type.getInternalName());
    }

    private Class getClassByDesc(String string) {
        return this.getClassByType(Type.getType(string));
    }

    public Type_[] createTypes(List list) {
        if (list == null) {
            return null;
        }
        Object[] objectArray = new Object[list.size()];
        Iterator iterator = list.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.createType((TypeDescriptor)iterator.next());
        }
        return objectArray;
    }

    public Type_ createType(TypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            return null;
        }
        if (typeDescriptor.arrayType != null) {
            return new GenericArrayTypeImpl(this.createType(typeDescriptor.arrayType));
        }
        if (typeDescriptor.typeVariable != null) {
            return this.findTypeVariable(typeDescriptor.typeVariable);
        }
        LinkedList linkedList = typeDescriptor.elements;
        if (linkedList != null) {
            return this.createClassType(linkedList.toArray(new ClassTypeElement[linkedList.size()]));
        }
        return RuntimeTools.getBaseClass(typeDescriptor.baseType);
    }

    private Type_ createClassType(ClassTypeElement[] classTypeElementArray) {
        class Element {
            Class rawType;
            List arguments;

            public Element(Class clazz, List list) {
                this.rawType = clazz;
                this.arguments = list;
            }
        }
        Object object;
        int n;
        String string = null;
        Object object2 = classTypeElementArray;
        int n2 = ((ClassTypeElement[])object2).length;
        for (n = 0; n < n2; ++n) {
            object = object2[n];
            string = (string == null ? "" : string + "$") + ((ClassTypeElement)object).getName();
        }
        object2 = new LinkedList();
        Class<?> clazz = this.getClassByInternalName(string);
        for (n = classTypeElementArray.length - 1; n >= 0; --n) {
            ((LinkedList)object2).addFirst(new Element(clazz, classTypeElementArray[n].getArguments()));
            clazz = clazz.getDeclaringClass();
            if (clazz == null) break;
        }
        Object object3 = ((Element)((LinkedList)object2).getFirst()).arguments.isEmpty() ? null : clazz;
        object = ((AbstractSequentialList)object2).iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            object3 = object3 == null && element.arguments.isEmpty() ? element.rawType : new ParameterizedTypeImpl(this.createArguments(element.arguments), element.rawType, (Type_)object3);
        }
        return object3;
    }

    private Type_[] createArguments(List list) {
        Object[] objectArray = new Object[list.size()];
        Iterator iterator = list.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            TypeArgument typeArgument = (TypeArgument)iterator.next();
            objectArray[i] = typeArgument.wildcard == '=' ? this.createType(typeArgument.descriptor) : new WildcardTypeImpl(typeArgument.wildcard == '+', this.getLazyType(typeArgument.descriptor));
        }
        return objectArray;
    }

    protected Annotation_ createAnnotation(AnnotationValue annotationValue) {
        Class clazz = this.getClassByDesc(annotationValue.getDesc());
        StringBuffer stringBuffer = new StringBuffer("@").append(clazz.getName()).append('(');
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean bl = true;
        Iterator iterator = ClassDescriptor.getInstance(clazz).getMethodDescriptors().iterator();
        while (iterator.hasNext()) {
            Object object;
            MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            String string = methodDescriptor.getName();
            Object object2 = annotationValue.getElement(string);
            Object object3 = object = object2 == null ? methodDescriptor.getDefaultValue() : this.resolveValue(object2, methodDescriptor.getReturnType(), methodDescriptor);
            if (object == null) {
                throw new IncompleteAnnotationException_(clazz, string);
            }
            hashMap.put(string, object);
            stringBuffer.append(string).append('=');
            AnnotatedElementDescriptor.append(stringBuffer, object);
        }
        stringBuffer.append(")");
        return (Annotation_)Proxy.newProxyInstance(this.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AnnotationHandler(clazz, stringBuffer.toString(), hashMap));
    }

    protected Object resolveValue(Object object, Class clazz, MethodDescriptor methodDescriptor) {
        if (object == null) {
            return null;
        }
        if (object instanceof Type) {
            object = this.getClassByType((Type)object);
        } else if (object instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)object;
            object = Enum_.valueOf(this.getClassByDesc(enumValue.getDescriptor()), enumValue.getValue());
        } else if (object instanceof AnnotationValue) {
            object = this.createAnnotation((AnnotationValue)object);
        } else if (object instanceof AnnotationArray) {
            AnnotationArray annotationArray = (AnnotationArray)object;
            Class<?> clazz2 = clazz.getComponentType();
            List list = annotationArray.getValues();
            object = Array.newInstance(clazz2, list.size());
            for (int i = Array.getLength(object) - 1; i >= 0; --i) {
                Array.set(object, i, this.resolveValue(list.get(i), clazz2, methodDescriptor));
            }
        }
        if (!clazz.isPrimitive() && !clazz.isInstance(object)) {
            throw new AnnotationTypeMismatchException_(methodDescriptor.getMethod(), clazz.getName());
        }
        return object;
    }

    private static void append(StringBuffer stringBuffer, Object object) {
        if (object.getClass().isArray()) {
            stringBuffer.append('[');
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                AnnotatedElementDescriptor.append(stringBuffer, Array.get(object, i));
            }
            stringBuffer.append(']');
        } else {
            stringBuffer.append(object);
        }
    }

    protected LazyValue getLazyType(TypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            return null;
        }
        return new LazyValue(typeDescriptor){

            protected Type_ resolve(TypeDescriptor typeDescriptor) {
                return AnnotatedElementDescriptor.this.createType(typeDescriptor);
            }
        };
    }

    protected LazyList getLazyList() {
        return new LazyList(){

            protected Type_ resolve(TypeDescriptor typeDescriptor) {
                return AnnotatedElementDescriptor.this.createType(typeDescriptor);
            }

            protected Type_[] newArray(int n) {
                return new Object[n];
            }
        };
    }
}

