/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import net.sf.retrotranslator.runtime.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.runtime.impl.AnnotationArray;
import net.sf.retrotranslator.runtime.impl.AnnotationValue;
import net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime.impl.EnumValue;
import net.sf.retrotranslator.runtime.impl.GenericDeclarationDescriptor;
import net.sf.retrotranslator.runtime.impl.LazyList;
import net.sf.retrotranslator.runtime.impl.LazyValue;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.impl.TypeDescriptor;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import net.sf.retrotranslator.runtime.java.lang.reflect.GenericDeclaration_;
import net.sf.retrotranslator.runtime.java.lang.reflect.TypeVariable_;
import net.sf.retrotranslator.runtime.java.lang.reflect.Type_;

public class MethodDescriptor
extends GenericDeclarationDescriptor {
    private String name;
    private String desc;
    private ClassDescriptor classDescriptor;
    private LazyValue method;
    private LazyValue returnType;
    private LazyValue defaultValue;
    private LazyValue constructor;
    private LazyValue genericReturnType;
    private LazyList genericParameterTypes;
    private LazyList genericExceptionTypes;
    private LazyList parameterAnnotations;

    public MethodDescriptor(ClassDescriptor classDescriptor, int n, String string, String string2, String string3) {
        this.classDescriptor = classDescriptor;
        this.access = n;
        this.name = string;
        this.desc = string2;
        if (string3 != null) {
            new SignatureReader(string3).accept(this);
        }
        this.returnType = this.createReturnType();
        if (string.equals("<init>")) {
            this.constructor = this.createConstructor();
        } else if (!string.equals("<clinit>")) {
            this.method = this.createMethod();
        }
        this.parameterAnnotations = this.createParameterAnnotations();
    }

    private LazyValue createReturnType() {
        return new LazyValue(this.desc){

            protected Class resolve(String string) {
                return MethodDescriptor.this.getClassByType(Type.getReturnType(string));
            }
        };
    }

    private LazyValue createConstructor() {
        return new LazyValue(this.classDescriptor.getTarget()){

            protected Constructor resolve(Class clazz) {
                Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                int n = constructorArray.length;
                for (int i = 0; i < n; ++i) {
                    Constructor<?> constructor = constructorArray[i];
                    if (!RuntimeTools.getConstructorDescriptor(constructor).equals(MethodDescriptor.this.desc)) continue;
                    return constructor;
                }
                return null;
            }
        };
    }

    private LazyValue createMethod() {
        return new LazyValue(this.classDescriptor.getTarget()){

            protected Method resolve(Class clazz) {
                Method[] methodArray = clazz.getDeclaredMethods();
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Method method = methodArray[i];
                    if (!method.getName().equals(MethodDescriptor.this.name) || !Type.getMethodDescriptor(method).equals(MethodDescriptor.this.desc)) continue;
                    return method;
                }
                return null;
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public Class getReturnType() {
        return (Class)this.returnType.get();
    }

    public Object getDefaultValue() {
        return this.defaultValue == null ? null : RuntimeTools.cloneNonEmptyArray(this.defaultValue.get());
    }

    public static MethodDescriptor getInstance(Method method) {
        String string = method.getName() + Type.getMethodDescriptor(method);
        MethodDescriptor methodDescriptor = ClassDescriptor.getInstance(method.getDeclaringClass()).getMethodDescriptor(string);
        methodDescriptor.method.provide(method);
        return methodDescriptor;
    }

    public static MethodDescriptor getInstance(Constructor constructor) {
        String string = "<init>" + RuntimeTools.getConstructorDescriptor(constructor);
        MethodDescriptor methodDescriptor = ClassDescriptor.getInstance(constructor.getDeclaringClass()).getMethodDescriptor(string);
        methodDescriptor.constructor.provide(constructor);
        return methodDescriptor;
    }

    public GenericDeclaration_ getTarget() {
        return this.method != null ? (Constructor)this.method.get() : (this.constructor != null ? (Constructor)this.constructor.get() : null);
    }

    public Method getMethod() {
        return this.method == null ? null : (Method)this.method.get();
    }

    public Constructor getConstructor() {
        return this.constructor == null ? null : (Constructor)this.constructor.get();
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    protected TypeVariable_ findTypeVariable(String string) {
        TypeVariable_ typeVariable_ = this.getTypeVariable(string);
        return typeVariable_ != null ? typeVariable_ : this.classDescriptor.findTypeVariable(string);
    }

    public Annotation_[][] getParameterAnnotations() {
        return (Annotation_[][])this.parameterAnnotations.getClone();
    }

    private LazyList createParameterAnnotations() {
        return new LazyList(){

            protected Annotation_[] resolve(List list) {
                return MethodDescriptor.this.createAnnotations(list);
            }

            protected Annotation_[][] newArray(int n) {
                return new Annotation_[Type.getArgumentTypes(MethodDescriptor.this.desc).length][];
            }
        };
    }

    public Type_ getGenericReturnType() {
        Object object;
        if (this.genericReturnType == null) {
            object = null;
        } else {
            object = this.genericReturnType.get();
            if (!(object instanceof Class)) {
                object = (Type_)object;
            }
        }
        return object;
    }

    public Type_[] getGenericParameterTypes() {
        return this.genericParameterTypes == null ? null : this.genericParameterTypes.getClone();
    }

    public Type_[] getGenericExceptionTypes() {
        return this.genericExceptionTypes == null ? null : this.genericExceptionTypes.getClone();
    }

    protected Annotation_[] createAnnotations(Annotation_[] annotation_Array) {
        return annotation_Array;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        if (!bl) {
            return null;
        }
        ArrayList<AnnotationValue> arrayList = (ArrayList<AnnotationValue>)this.parameterAnnotations.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<AnnotationValue>();
            this.parameterAnnotations.set(n, arrayList);
        }
        AnnotationValue annotationValue = new AnnotationValue(string);
        arrayList.add(annotationValue);
        return annotationValue;
    }

    public void visit(String string, Object object) {
        this.setDefaultValue(object);
    }

    public void visitEnum(String string, String string2, String string3) {
        this.setDefaultValue(new EnumValue(string2, string3));
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        AnnotationValue annotationValue = new AnnotationValue(string2);
        this.setDefaultValue(annotationValue);
        return annotationValue;
    }

    public AnnotationVisitor visitArray(String string) {
        AnnotationArray annotationArray = new AnnotationArray();
        this.setDefaultValue(annotationArray);
        return annotationArray;
    }

    public SignatureVisitor visitParameterType() {
        TypeDescriptor typeDescriptor = new TypeDescriptor();
        if (this.genericParameterTypes == null) {
            this.genericParameterTypes = this.getLazyList();
        }
        this.genericParameterTypes.add(typeDescriptor);
        return typeDescriptor;
    }

    public SignatureVisitor visitReturnType() {
        TypeDescriptor typeDescriptor = new TypeDescriptor();
        this.genericReturnType = this.getLazyType(typeDescriptor);
        return typeDescriptor;
    }

    public SignatureVisitor visitExceptionType() {
        TypeDescriptor typeDescriptor = new TypeDescriptor();
        if (this.genericExceptionTypes == null) {
            this.genericExceptionTypes = this.getLazyList();
        }
        this.genericExceptionTypes.add(typeDescriptor);
        return typeDescriptor;
    }

    private void setDefaultValue(Object object) {
        this.defaultValue = new LazyValue(object){

            protected Object resolve(Object object) {
                return MethodDescriptor.this.resolveValue(object, MethodDescriptor.this.getReturnType(), MethodDescriptor.this);
            }
        };
    }
}

