/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.java.lang.reflect.Type_;

public class RuntimeTools {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_NAME = "<clinit>";

    public static Class getBaseClass(char c) {
        return RuntimeTools.getBaseClass(Type.getType(new String(new char[]{c})));
    }

    public static Class getBaseClass(Type type) {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
        }
        return null;
    }

    public static String getConstructorDescriptor(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer("(");
        Class<?>[] classArray2 = classArray;
        int n = classArray2.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz = classArray2[i];
            stringBuffer.append(Type.getDescriptor(clazz));
        }
        return stringBuffer.append(")V").toString();
    }

    public static Object cloneNonEmptyArray(Object object) {
        if (!object.getClass().isArray() || Array.getLength(object) == 0) {
            return object;
        }
        if (object instanceof Object[]) {
            return ((Object[])object).clone();
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).clone();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        if (object instanceof char[]) {
            return ((char[])object).clone();
        }
        if (object instanceof double[]) {
            return ((double[])object).clone();
        }
        if (object instanceof float[]) {
            return ((float[])object).clone();
        }
        if (object instanceof int[]) {
            return ((int[])object).clone();
        }
        if (object instanceof long[]) {
            return ((long[])object).clone();
        }
        if (object instanceof short[]) {
            return ((short[])object).clone();
        }
        throw new IllegalStateException();
    }

    public static String getString(Type_ type_) {
        if (!(type_ instanceof Class)) {
            return type_.toString();
        }
        Class<?> clazz = (Class<?>)((Object)type_);
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        if (n == 0) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(clazz.getName());
        while (n > 0) {
            stringBuffer.append("[]");
            --n;
        }
        return stringBuffer.toString();
    }

    public static StringBuffer append(StringBuffer stringBuffer, Type_[] type_Array) {
        for (int i = 0; i < type_Array.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(RuntimeTools.getString(type_Array[i]));
        }
        return stringBuffer;
    }
}

