/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.java.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class _Arrays {
    private static final String NULL = "null";
    private static final String EMPTY_ARRAY = "[]";
    private static final char LEFT_BRACKET = '[';
    private static final char RIGHT_BRACKET = ']';
    private static final String SEPARATOR = ", ";

    public static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        return _Arrays.isEqual(objectArray, objectArray2);
    }

    public static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        Object[] objectArray2 = objectArray;
        int n2 = objectArray2.length;
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray2[i];
            n = 31 * n + _Arrays.getHashCode(object);
        }
        return n;
    }

    public static String deepToString(Object[] objectArray) {
        if (objectArray == null) {
            return NULL;
        }
        StringBuffer stringBuffer = new StringBuffer();
        _Arrays.appendArray(stringBuffer, objectArray, new HashSet());
        return stringBuffer.toString();
    }

    public static int hashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n = 1;
        boolean[] blArray2 = blArray;
        int n2 = blArray2.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl = blArray2[i];
            n = 31 * n + (bl ? 1231 : 1237);
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        byte[] byArray2 = byArray;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray2[i];
            n = 31 * n + by;
        }
        return n;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 1;
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray2[i];
            n = 31 * n + c;
        }
        return n;
    }

    public static int hashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 1;
        double[] dArray2 = dArray;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            long l = Double.doubleToLongBits(d);
            n = 31 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public static int hashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 1;
        float[] fArray2 = fArray;
        int n2 = fArray2.length;
        for (int i = 0; i < n2; ++i) {
            float f = fArray2[i];
            n = 31 * n + Float.floatToIntBits(f);
        }
        return n;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray2[i];
            n = 31 * n + n3;
        }
        return n;
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = 1;
        long[] lArray2 = lArray;
        int n2 = lArray2.length;
        for (int i = 0; i < n2; ++i) {
            long l = lArray2[i];
            n = 31 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        Object[] objectArray2 = objectArray;
        int n2 = objectArray2.length;
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray2[i];
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = 1;
        short[] sArray2 = sArray;
        int n2 = sArray2.length;
        for (int i = 0; i < n2; ++i) {
            short s = sArray2[i];
            n = 31 * n + s;
        }
        return n;
    }

    public static String toString(boolean[] blArray) {
        if (blArray == null) {
            return NULL;
        }
        if (blArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(blArray[0]);
        for (int i = 1; i < blArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(blArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return NULL;
        }
        if (byArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(byArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return NULL;
        }
        if (cArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(cArray[0]);
        for (int i = 1; i < cArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(cArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return NULL;
        }
        if (dArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(dArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return NULL;
        }
        if (fArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(fArray[0]);
        for (int i = 1; i < fArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(fArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return NULL;
        }
        if (nArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(nArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return NULL;
        }
        if (lArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(lArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return NULL;
        }
        if (objectArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(objectArray[0]);
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(objectArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    public static String toString(short[] sArray) {
        if (sArray == null) {
            return NULL;
        }
        if (sArray.length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(sArray[0]);
        for (int i = 1; i < sArray.length; ++i) {
            stringBuffer.append(SEPARATOR).append(sArray[i]);
        }
        return stringBuffer.append(']').toString();
    }

    private static void appendArray(StringBuffer stringBuffer, Object[] objectArray, Set set) {
        int n = objectArray.length;
        if (n == 0) {
            stringBuffer.append(EMPTY_ARRAY);
            return;
        }
        if (!set.add(objectArray)) {
            stringBuffer.append("[...]");
            return;
        }
        _Arrays.appendObject(stringBuffer.append('['), objectArray[0], set);
        for (int i = 1; i < n; ++i) {
            _Arrays.appendObject(stringBuffer.append(SEPARATOR), objectArray[i], set);
        }
        stringBuffer.append(']');
    }

    private static void appendObject(StringBuffer stringBuffer, Object object, Set set) {
        if (object instanceof Object[]) {
            _Arrays.appendArray(stringBuffer, (Object[])object, set);
        } else {
            stringBuffer.append(_Arrays.getString(object));
        }
    }

    private static int getHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return _Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof boolean[]) {
            return _Arrays.hashCode((boolean[])object);
        }
        if (object instanceof byte[]) {
            return _Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return _Arrays.hashCode((char[])object);
        }
        if (object instanceof double[]) {
            return _Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return _Arrays.hashCode((float[])object);
        }
        if (object instanceof int[]) {
            return _Arrays.hashCode((int[])object);
        }
        if (object instanceof long[]) {
            return _Arrays.hashCode((long[])object);
        }
        if (object instanceof short[]) {
            return _Arrays.hashCode((short[])object);
        }
        return object.hashCode();
    }

    private static String getString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof boolean[]) {
            return _Arrays.toString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return _Arrays.toString((byte[])object);
        }
        if (object instanceof char[]) {
            return _Arrays.toString((char[])object);
        }
        if (object instanceof double[]) {
            return _Arrays.toString((double[])object);
        }
        if (object instanceof float[]) {
            return _Arrays.toString((float[])object);
        }
        if (object instanceof int[]) {
            return _Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return _Arrays.toString((long[])object);
        }
        if (object instanceof short[]) {
            return _Arrays.toString((short[])object);
        }
        return object.toString();
    }

    private static boolean isEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])object2;
            if (n != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (_Arrays.isEqual(objectArray[i], objectArray2[i])) continue;
                return false;
            }
            return true;
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof short[] && object2 instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        return object.equals(object2);
    }
}

