
function [out] = G(t,y,flag,ratedata)

% unpack ratedata
incident=ratedata{1};
exident=ratedata{2};

Trate=1/200;


[numreac,numspec]=size(incident);

conc=y(1:numspec,1);
T=y(numspec+1,1);

% very bad coding practice -- changing density
rho=ratedata{3};
ratedata{3}=rho*exp(-Trate*t);


if isempty(flag)==0
  if flag=='jacobian'
    reacgrad=getgrad(conc,T,ratedata);
    out=(exident-incident)'*reacgrad;
    out(numspec+1,:)=0;
    out(numspec+1,numspec+1)=-Trate;
    out=sparse(out);
    return
  end
end

rates=getrates(conc,T,ratedata);

out=(exident-incident)'*rates;

% derivative of temperature
out(numspec+1,1)=-Trate*T;



