clear nr r Y tmore ymore T R rop

tol=1e-6      
rtol=1e-6
fudgetol=10

stepcounter=1;

[numreac,numspec]=size(fullratedata{1});

% Set up initial condition vector
clear Y
Y=initial';
R(1,1:numreac)=ones(1,numreac);
T(1,1)=0.0;

backtracks=0;
finished=0;
overhead=0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Start Loop                                %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
while finished==0 

  disp('**************************************************************')
  stepcounter

  [totlen,totwid]=size(Y);

  [r,steplength]=getmodel(Y(totlen,:),fullratedata,tol,rtol,fudgetol);

  done=0;

  while done==0,

    ratedata=reducemodel(fullratedata,r);

    clear tmore ymore
    if steplength>=tottime-T(totlen,1)
      steplength=tottime-T(totlen,1);
    end
    time=T(totlen,1)
    steplength

   [tmore,ymore]=besol('G',[T(totlen,1) T(totlen,1)+steplength],Y(totlen,:)',betol,10,ratedata);

% Calculate Rates at End of Step
    [len,wid]=size(ymore);
    rates=getrates(ymore(len,1:numspec)',ymore(len,numspec+1),fullratedata);

% Check if rates are still below tol at end of step: include if they are
    redo=0.0;
    redovect=( ~r & isimp(rates,fudgetol*tol,fudgetol*rtol) );
    redo=sum(redovect);

    if redo==0.0
      done=1;
      Y(totlen:totlen+len-1,:)=ymore;
      T(totlen:totlen+len-1,:)=tmore;
      R(totlen:totlen+len-1,:)=ones(len,1)*r';
      R=sparse(R);
      stepcounter=stepcounter+1;
      [totlen,totwid]=size(Y);
      if T(totlen,1)>=tottime
        finished=1;
      end
    else
      finished=0;
      disp('step rejected')
      find(redovect)
      r=r|redovect;
      backtracks=backtracks+1
    end

  end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  End loop
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

backtracks
stepcounter

nr=sum( R')';

