function [tout,yout]= besol(odefile,tottspan,y0,tol,maxsteps,varargin)

parameters=varargin{:};

facmax=500;
fac=0.5;

tottime=tottspan(2)-tottspan(1);

tout(1,1)=tottspan(1);
yout(1,:)=y0';

steps_rejected=0;

i=1;

% Get length of first step
d=max(abs(yout(i,:)'),1e-6);
pert=1e-10;
ff=feval(odefile,tottspan(1),y0,[],varargin{:});
ff1=feval(odefile,tottspan(1),y0+pert*ff,[],varargin{:});
gff= (ff1-ff)/pert;
h=fac*sqrt( tol/ max( gff./d ) );

done=0;
while done==0 & i<maxsteps+1
  stepgood=0;
  while stepgood==0
    if tout(i,:)+h>=tottspan(2)
      h=tottspan(2)-tout(i,1)
      done=1;
    end
    if h==0
      error('h is 0')
    end
    time=tout(i,1)
    tspan=[time time+h ];
    tspanmid1=[time time+h/2 ];
    tspanmid2=[time+h/2 time+h];
    % Backward Euler Step
    sol1=bestep(odefile,tspan,yout(i,:)',[],parameters);
    solmid=bestep(odefile,tspanmid1,yout(i,:)',[],parameters);
    sol2=bestep(odefile,tspanmid2,solmid',[],parameters);
    % Check if error is small enough
    d=max(max(abs(yout(i,:)),abs(sol2)),1e-6);
    err=max(abs(sol1-sol2)./d);
    if err<tol
      % Keep step
      stepgood=1;
      yout(i+1,:)=sol2;
      tout(i+1,1)=tout(i,1)+h;
      i=i+1;
    else
      % Reject step
      disp('step rejected')
      steps_rejected=steps_rejected+1;
      done=0;
    end
    h=h*min(facmax,fac*sqrt(tol/err))
  end
end

steps_rejected

