
function [out]=bestep(odefile,tspan,state,options,varargin)

% Set tolerance for solution of implicit equation
  itol=1e-3;
% Maximum Number of newton iterations.
  itnum=4;

  begintime=tspan(1);
  endtime=tspan(2);
  h=endtime-begintime;

  vectlen=length(state);
  thresh=1e-4*ones(vectlen,1);

  i=1;

% Use intial postion as guess for newton iteration
  w(:,i)=state;

% Function evaluation here.
  FTY=feval(odefile,begintime,state,[],varargin{:});

  err=100;
% iterate itnum times
  while (err>itol)&(i<=itnum)
    Jac=feval(odefile,endtime,w(:,i),'jacobian',varargin{:});
    maty=sparse(eye(vectlen)-h*Jac);
    %newtstep= - (eye(vectlen)-h*Jac)\( w(:,i) - state - h*FTY);
    newtstep= - maty\( w(:,i) - state - h*FTY);
    w(:,i+1)=w(:,i) +newtstep;
    err=norm(newtstep);
    FTY=feval(odefile,begintime,w(:,i+1),[],varargin{:});
    i=i+1;
  end

  if err>itol
    disp('failure to converge in bestep')
    noncon=1;
  end

  out=w(:,i)';

  out=max(out,0);



