
function out=getgrad( conc, T9, ratedata )

% Unpack ratedata
rho=ratedata{3};
condaco=ratedata{4};
maxterm=ratedata{5};
reacon=ratedata{6};
incoming=ratedata{7};
a1=ratedata{8};
a2=ratedata{9};
in1=ratedata{10};
in2=ratedata{11};
a3=ratedata{12};
a4=ratedata{13};
out1=ratedata{14};
out2=ratedata{15};

numspec=length(conc);
numreac=length(incoming);

% Set dummy value to conc arbitrarily
conc=[conc' 1]';

conc1=conc(in1,1);
conc2=conc(in2,1);

chop=(conc1>=0).*(conc2>=0);
conc1=conc1.*chop;
conc2=conc2.*chop;

%conc1=max(conc1,0);
%conc2=max(conc2,0);

% make Tstuff vector
Tstuff(1,1)=1.;
Tstuff(2,1)=1/T9;
Tstuff(3,1)=T9^(-1/3);
%Tstuff(4,1)=T9^(-1/4);
Tstuff(4,1)=T9^(1/3);
Tstuff(5,1)=T9;
Tstuff(6,1)=T9^(5/3);
Tstuff(7,1)=log(T9);

% stuff for computing gradient w.r.t. temperature
Tgrad(1,1)=0.;
Tgrad(2,1)=-1/T9^2;
Tgrad(3,1)=(-1/3)*T9^(-4/3);
Tgrad(4,1)=(1/3)*T9^(-2/3);
Tgrad(5,1)=1.;
Tgrad(6,1)=(5/3)*T9^(2/3);
Tgrad(7,1)=1/T9;

% for each term
for j=1:maxterm
  hold=condaco{j};
  thing=exp(hold*Tstuff);
  kco(reacon{j},j)=thing;
  kcograd(reacon{j},j)=(hold*Tgrad).*thing;
end
K=sum(kco,2);
Kgrad=sum(kcograd,2);

conc1star=conc1.*(in1<numspec+1);
exp1=(a1-1).*(a1>0);
fact1=K.*a1.*(conc1.^exp1).*(conc2.^a2).*(rho.^incoming)/rho;
out1=sparse(in1,1:numreac,fact1,numspec+1,numreac);

conc2star=conc2.*(in2<numspec+1);
exp2=(a2-1).*(a2>0);
fact2=K.*a2.*(conc1.^a1).*(conc2.^exp2).*(rho.^incoming)/rho;
out2=sparse(in2,1:numreac,fact2,numspec+1,numreac);

%remove last row
out1=out1(1:numspec,1:numreac)';
out2=out2(1:numspec,1:numreac)';


out=out1+out2;

% last row
out(:,numspec+1)= Kgrad.*(conc1.^a1).*(conc2.^a2).*(rho.^incoming)/rho;



