
function [r,steplength]=getmodel(Y,fullratedata,tol,rtol,fudgetol)

weight=30;

% perturbation for finite differences
  pert=1e-10;

  numspec=length(Y)-1;

% Compute rates at this point
  rates=getrates(Y(1,1:numspec)',Y(1,numspec+1),fullratedata);
  sumrates=sum(abs(rates));

% Decide which rates to turn on
  r= isimp(rates,tol,rtol);

% output how many reactions for tentative reduced model
  tentative_model_size=sum(r)

% Iteration to decide upon final reduced model
  finishedreduction=0;
  while finishedreduction==0
% Reduce the model
    ratedata=reducemodel(fullratedata,r);
% Determine growths of omitted reactions
  % Rate of change of species with reduced model
    v=G(0.0,Y(1,1:numspec+1)',[],ratedata);
  % Finite Difference to get reaction rate change
    pertrates=getrates(Y(1,1:numspec)'+pert*v(1:numspec,1),Y(1,numspec+1)+pert*v(numspec+1,1),fullratedata);
    growthvect=((pertrates-rates)/pert).*~r;
    [a,b]=sort(-abs(growthvect));
    a=-a;
    brek=min(find(a<=0));
    clear opti stepls
    stepls=getsteplength(a(1:brek,1),tol,rtol,fudgetol,sumrates);
    opti=weight./stepls + (1:brek)' ;
    [opt,optind]=min(opti)
    if optind==1
      finishedreduction=1;
    else
      r(b(1:optind-1))=1;    
    end
  end

% output how many reactions for final reduced model
  model_size=sum(r)
  disp('reactions included')
  find(r)'

% steplength for final reduced model
  maxgrowth=max(abs(growthvect))
  steplength=getsteplength(maxgrowth,tol,rtol,fudgetol,sumrates);
  disp('macrosteplength')
  steplength

