
function rates=getrates( conc, T9, ratedata )

% Unpack ratedata
rho=ratedata{3};
condaco=ratedata{4};
maxterm=ratedata{5};
reacon=ratedata{6};
incoming=ratedata{7};
a1=ratedata{8};
a2=ratedata{9};
in1=ratedata{10};
in2=ratedata{11};
a3=ratedata{12};
a4=ratedata{13};
out1=ratedata{14};
out2=ratedata{15};

% Set dummy value to conc arbitrarily
conc=[conc' 1]';

conc1=conc(in1,1);
conc2=conc(in2,1);

% make Tstuff vector
Tstuff(1,1)=1.;
Tstuff(2,1)=1/T9;
Tstuff(3,1)=T9^(-1/3);
%Tstuff(4,1)=T9^(-1/4);
Tstuff(4,1)=T9^(1/3);
Tstuff(5,1)=T9;
Tstuff(6,1)=T9^(5/3);
Tstuff(7,1)=log(T9);


% for each term
for j=1:maxterm
  hold=condaco{j};
  kco(reacon{j},j)=exp(hold*Tstuff);
end
K=sum(kco,2);

conc1=max(conc1,0);
conc2=max(conc2,0);


rates= K.*(conc1.^a1).*(conc2.^a2).*(rho.^incoming)/rho;



