
format compact
 

clf

sind=[7 8 58];

fs=18;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Nova
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load nova
[newT,newnr]=fixnr(T,nr);

% Plot number 1
clf
set(gca,'FontSize',fs);
semilogx(newT,newnr)
axis([1e-5 1e2 0 1000])
title('Number of Reactions');
ylabel('1','Rotation',0);
print -deps aplot1

% Plot number 2
clf
set(gca,'FontSize',fs);
semilogx(realt,realy(:,sind(1)),'k')
hold
semilogx(T,Y(:,sind(1)),'k--')
axis([1e-5 1e2 0 3e-5])
title('C^{12}')
print -deps aplot2

% Plot number 3
clf
set(gca,'FontSize',fs);
semilogx(realt,realy(:,sind(2)),'k')
hold
semilogx(T,Y(:,sind(2)),'k--')
axis([1e-5 1e2 0 6e-5])
title('O^{16}')
print -deps aplot3

% Plot number 4
clf
set(gca,'FontSize',fs);
semilogx(realt,realy(:,sind(3)),'k')
hold
semilogx(T,Y(:,sind(3)),'k--')
axis([1e-5 1e2 0 1.2e-6])
title('Al^{25}')
print -deps aplot4

[reallen,realwid]=size(realy);
[len,wid]=size(Y);

disp('error for paper')
norm( realy(reallen,:)-Y(len,:))


load supernova

bt=1e-4
et=1e2

subplot(4,4,5); 
set(gca,'FontSize',6);
[newT,newnr]=fixnr(T,nr);
semilogx(newT,newnr)

for i=1:3

  subplot(4,4,i+5)
set(gca,'FontSize',6);
  semilogx(realt,realy(:,sind(i)),'k')
  hold
  semilogx(T,Y(:,sind(i)),'k--')

end

subplot(4,4,5)
set(gca,'FontSize',6);
axis([bt et 0 1000])
ylabel('2')

subplot(4,4,6)
set(gca,'FontSize',6);
axis([bt et 0 3e-5])

subplot(4,4,7)
set(gca,'FontSize',6);
axis([bt et 0 6e-5])

subplot(4,4,8)
set(gca,'FontSize',6);
axis([bt et 0 1.2e-6])

[reallen,realwid]=size(realy);
[len,wid]=size(Y);

disp('error for paper')
norm( realy(reallen,:)-Y(len,:))


load xray

bt=1e-10
et=1e-7

subplot(4,4,9)
set(gca,'FontSize',6);
[newT,newnr]=fixnr(T,nr);
semilogx(newT,newnr)

for i=1:3

  subplot(4,4,i+9)
set(gca,'FontSize',6);
  semilogx(realt,realy(:,sind(i)),'k')
  hold
  semilogx(T,Y(:,sind(i)),'k--')

end

subplot(4,4,9)
set(gca,'FontSize',6);
axis([bt et 0 1000])
ylabel('3')

subplot(4,4,10)
set(gca,'FontSize',6);
axis([bt 1e-5 0 2e-5])

subplot(4,4,11)
set(gca,'FontSize',6);
axis([bt et 0 6e-5])

subplot(4,4,12)
set(gca,'FontSize',6);
axis([bt et 0 7e-7])

[reallen,realwid]=size(realy);
[len,wid]=size(Y);

disp('error for paper')
norm( realy(reallen,:)-Y(len,:))


load tz

bt=1e-7
et=1e-2

subplot(4,4,13)
set(gca,'FontSize',6);
[newT,newnr]=fixnr(T,nr);
semilogx(newT,newnr)

for i=1:3

  subplot(4,4,i+13)
set(gca,'FontSize',6);
  semilogx(realt,realy(:,sind(i)),'k')
  hold
  semilogx(T,Y(:,sind(i)),'k--')

end

subplot(4,4,13)
set(gca,'FontSize',6);
axis([bt et 0 1000])
ylabel('4')

subplot(4,4,14)
set(gca,'FontSize',6);
axis([bt et 0 4e-5])

subplot(4,4,15)
set(gca,'FontSize',6);
axis([bt et 0 8e-5])

subplot(4,4,16)
set(gca,'FontSize',6);
axis([bt et 0 1.5e-7])

[reallen,realwid]=size(realy);
[len,wid]=size(Y);

disp('error for paper')
norm( realy(reallen,:)-Y(len,:))

