
lenspecname=9;

clear specs
clear line
clear cp
clear Hf

fid=fopen('nucleo.dat','rt');

% Get first line containing the number of species
line=fgetl(fid);
disp(line)
numspec=str2num(line(1:5));

% Get throwaway header line
line=fgetl(fid);

% Get species data
for i=1:numspec
  line=fgetl(fid);
  disp(line)
  specs{i}=line(6:10);
  Aspec(i,1)=str2num(line(11:14)); % this should be in cal/mol/K
  Zspec(i,1)=str2num( line(16:18)); % this should be in cal/mol/K
end

% Get number of isotopes that have initial quantities
line=fgetl(fid);
disp(line)
numiso=str2num(line(1:5));

% Get initial conditions
initc=zeros(numspec,1);
for i=1:numiso
  line=fgetl(fid);
  disp(line)
  specinit=line(6:10);
  kk=findy(specinit,specs);
  initc(kk,1)=str2num(line(33:44));
end

% normalize initc
initc=initc/sum(initc);
initc=initc./Aspec;

% Get number of reactions in the system
line=fgetl(fid);
disp(line)
numreac=str2num(line(1:6));

% Get reactions
for i=1:numreac
  line=fgetl(fid);
  disp(line)
  % Get coefficients of reactions
  a1(i,1)=str2num(line(9:10));
  a2(i,1)=str2num(line(19:20));
  a3(i,1)=str2num(line(28:29));
  a4(i,1)=str2num(line(38:39));
  % Get species in reactions
  s1{i}=line(12:16);
  s2{i}=line(22:26);
  s3{i}=line(31:35);
  s4{i}=line(41:45);
end

st=fclose(fid);


