
% this program gets reaction rate coefficients

initmaxterm=10;

% set up coefficient matrices
for i=1:initmaxterm
  aco{i}=zeros(numreac,7);
end

fid=fopen('reactions.dat','rt');

% get throwaway first line
line=fgetl(fid);

counter=0;
oldstring='****************************************';


line=fgetl(fid);
while (isstr(line))
  % get first character of this line
  flag=str2num(line(1:1));
  if flag==0
    % We have a reaction string
    reacstring=line(1:40);
    if max((reacstring~=oldstring))>0
      % We have a new reaction
      oldstring=reacstring;
      if(counter>0)
	numterm(counter)=termcount;
      end 
      termcount=1;
      counter=counter+1
    else
      % Another term of the same reaction
      termcount=termcount+1;
    end
    % Get coefficients
    line=fgetl(fid);
    kco(1)=str2num(line(1:13));
    kco(2)=str2num(line(14:26));
    kco(3)=str2num(line(27:39));
    kco(4)=str2num(line(40:52));
    line=fgetl(fid);
    kco(5)=str2num(line(1:13));
    kco(6)=str2num(line(14:26));
    kco(7)=str2num(line(27:39));
    % put into aco
    holdy=aco{termcount};
    holdy(counter,:)=kco;
    aco{termcount}=holdy;
  else
    % Just some crap
    line=fgetl(fid);
    line=fgetl(fid);
  end
  line=fgetl(fid);
end

numterm(counter)=termcount;

% maximum number of terms per reaction
maxterm=max(numterm);

st=fclose(fid);

% Create arrays of reactions that have 1 term, 2 terms, 3 terms, etc.
for i=1:maxterm
  reacon{i}=find(numterm>=i);
end

% condense aco
for i=1:maxterm 
  holdy=aco{i};
  condaco{i}=holdy(reacon{i},:);
end

