
function ratedata=reducemodel(fullratedata,r)

% unpack fullratedata
  fullincident=full(fullratedata{1});
  fullexident=full(fullratedata{2});
  fullcondaco=fullratedata{4};
  maxterm=fullratedata{5};
  fullreacon=fullratedata{6};
  fullincoming=fullratedata{7};
  fulla1=fullratedata{8};
  fulla2=fullratedata{9};
  fullin1=fullratedata{10};
  fullin2=fullratedata{11};
  fulla3=fullratedata{12};
  fulla4=fullratedata{13};
  fullout1=fullratedata{14};
  fullout2=fullratedata{15};

%  reduce
  incident=fullincident(find(r),:);
  exident=fullexident(find(r),:);
  for k=1:maxterm
    fullhold=fullreacon{k};
    [hold,ia,ib]=intersect(fullhold,find(r));
    reacon{k}=ib;

    fullhold=fullcondaco{k};
    hold=fullhold(ia,:);
    condaco{k}=hold;

  end 

  incoming=fullincoming(find(r),1);
  a1=fulla1(find(r),1);
  a2=fulla2(find(r),1);
  in1=fullin1(find(r),1);
  in2=fullin2(find(r),1);
  a3=fulla3(find(r),1);
  a4=fulla4(find(r),1);
  out1=fullout1(find(r),1);
  out2=fullout2(find(r),1);

    
% pack into ratedata
  ratedata{1}=sparse(incident);
  ratedata{2}=sparse(exident);
  ratedata{3}=fullratedata{3};
  ratedata{4}=condaco;
  ratedata{5}=fullratedata{5};
  ratedata{6}=reacon;
  ratedata{7}=incoming;
  ratedata{8}=a1;
  ratedata{9}=a2;
  ratedata{10}=in1;
  ratedata{11}=in2;
  ratedata{12}=a3;
  ratedata{13}=a4;
  ratedata{14}=out1;
  ratedata{15}=out2;


