
format compact

clear  Y
tottime=100;

betol=1e-2;

temps=[ 0.2 0.25 1.5 2 ];
dens= [ 5e3 50 1.5e6 3e3 ];
name{1}='nova';
name{2}='supernova';
name{3}='xray';
name{4}='tz'; 

for jjj=1:4

  diary(name{jjj})
  
  % Set up initial condition vector
  initial(1:numspec,1)=initc;
  initial(numspec+1,1)=temps(jjj);

  % Set rho
  fullratedata{3}=dens(jjj);

  tic;
  [tmore,ymore]=besol('G',[0 tottime],initial,betol,1e4,fullratedata);
  toc

  realy=ymore;
  realt=tmore;

  clear ymore tmore

  tic;
  besmart;
  toc

  save(name{jjj})

  diary off

end




