
function [out] = G(t,y,flag,ratedata)

% unpack ratedata
incident=ratedata{1};
exident=ratedata{2};
tbincident=ratedata{3};
A=ratedata{4};
m=ratedata{5};
E=ratedata{6};
cp=ratedata{7};
Hf=ratedata{8};

[numreac,numspec]=size(incident);

conc=y(1:numspec,1);
T=y(numspec+1,1);

[forrate,backrate]=getrates(conc,T,ratedata);

out=(exident-incident)'*(forrate - backrate);

% derivative of temperature
totcp=dot(cp,conc);
out(numspec+1,1)=-Hf'*out(1:numspec,1)*1000/totcp;


