clear nr temp T R
clear r Y tmore ymore 

%optreloff=odeset('reltol',1e-9,'abstol',1e-7,'stats','on');
optreloff=odeset('reltol',1e-5,'abstol',1e-3,'stats','on');

% Number of Macrosteps
K=10;


[numreac,numspec]=size(fullincident);

% Set up initial condition vector
Y(1,1:numspec)=conc';
Y(1,numspec+1)=temperature;
T(1,1)=0;

for kk=1:K
  
  [len,wid]=size(Y);
  [forward,backward]=getrates(Y(len,1:numspec)',Y(len,numspec+1),fullratedata);
  rates=forward-backward;

  r=abs(rates)>tol;
  ratedata=reducemodel(fullratedata,r);

  [tmore,ymore]=my23tb('G',[T(len,1) T(len,1)+tottime/K],Y(len,:)',optreloff,ratedata);

  [addlen,addwid]=size(ymore);

  Y(len:len+addlen-1,:)=ymore;
  T(len:len+addlen-1,:)=tmore;
  R(len:len+addlen-1,1:numreac)=ones(addlen,1)*r';

end

temp=Y(:,numspec+1);
nr=sum(R,2);



