
function [forward,reverse]=getrates( conc, T, ratedata )

% Unpack ratedata
incident=ratedata{1};
exident=ratedata{2};
tbincident=ratedata{3};
A=ratedata{4};
m=ratedata{5};
E=ratedata{6};
enhafact=ratedata{9};
delS0=ratedata{10};
delH0=ratedata{11};
rever=ratedata{12};

% Gas constant in cal/mol/K
R=1.986;

% 1atm. pressure in cal/cm^3
P=.0242;

% total number of mols of gas
n=real(sum(conc));

% volume in cm^3
V=(n*R*T)/P;

[numreac,numspec]=size(incident);

matconc=(conc*ones(1,numreac))';

% effective third-body concentration including enhancement factor
%effn=sum( real(matconc).*enhafact,2);
effn=enhafact*conc;

incoming=sum(incident,2)+tbincident;
outgoing=sum(exident,2)+tbincident;
sumstoich=sum(exident-incident,2);

kf=A.*(T.^m).*exp(-E/(R*T));
if rever==1
  bigK=exp( (delS0-delH0/T)/R ) .* (P/R/T).^sumstoich;
  kr=kf./bigK;
else
  kr=zeros(numreac,1);
end

forward=V*kf.*prod(matconc.^incident,2).*effn.^tbincident./(V.^incoming);
reverse=V*kr.*prod(matconc.^exident,2).*effn.^tbincident./(V.^outgoing);

