
format compact

if system==1 
  numspec=32
  numreac=177
  reacfile='justreac.dat'
  specfile='thermo.dat'
  enha=0
  rever=1
elseif system==2
  numspec=3
  numreac=6
  reacfile='threereac.dat'
  specfile='threethermo.dat'
  enha=1
  rever=0
elseif system==3
  numspec=8
  numreac=20
  reacfile='tworeac.dat'
  specfile='twothermo.dat'
  enha=1
end

readreac
readspec

incident=zeros(numreac,numspec);
exident=zeros(numreac,numspec);
tbincident=zeros(numreac,1);
A=zeros(numreac,1);
m=zeros(numreac,1);
E=zeros(numreac,1);

for i=1:numreac
  line=reacs{i}
  bre=findstr(line,'<=>');
  for j=1:numspec
    fullspec=specs{j};
    firstblank=findstr(fullspec,' ');
    speclength=firstblank(1)-1;
    shortspec=fullspec(1:speclength);
% see if shortspec is in fact in the string
    poss=findstr(line,shortspec);
    if length(poss)>0
% then it is in string
      w=length(poss);
      for k=1:w
        sta=poss(k);
        fin=sta+speclength-1;
        next=line(fin+1);
        if sta~=1
	  bef=line(sta-1);
        end
        if sta<bre
% then it is incident
	  if ((next=='+')|(next=='<'))
            if (sta==1) 
	      incident(i,j)=1;
	    elseif bef=='+'
	      incident(i,j)=1;
	    elseif (bef=='2' & (sta==2 | line(sta-2)=='+'))
	      incident(i,j)=2;
	    elseif (bef=='3' & (sta==2 | line(sta-2)=='+'))
	      incident(i,j)=3;
            end
          end
        else
% then it is exident
	  if ((next=='+')|(next==' '))
	    if (bef=='2'  & (line(sta-2)=='>' | line(sta-2)=='+'))
	      exident(i,j)=2;
	    elseif (bef=='3' & (line(sta-2)=='>' | line(sta-2)=='+'))
	      exident(i,j)=3;
	    elseif (bef=='>' | bef=='+')
	      exident(i,j)=1;
            end
          end
	end   
      end
    end
  end
% Any third body interaction?
  if findstr(line,'+M')>0 
    tbincident(i)=1;
  end
  A(i)=str2num(line(40:50));
  m(i)=str2num(line(52:60));
  E(i)=str2num(line(62:70));
end

% Get enhancement factors for third-body interactions
if enha==0
  grienha
elseif enha==1
  for i=1:numreac
    enhafact(i,1:numspec)=str2num(enhaline{i});
  end
else
  enhafact=ones(numreac,numspec);
end

% reverse reaction stuff
stoich=exident-incident;
delS0=stoich*S;
delH0=stoich*Hf*1000;
sumstoich=sum(stoich,2);
 
ratedata{1}=incident;
ratedata{2}=exident;
ratedata{3}=tbincident;
ratedata{4}=A;
ratedata{5}=m;
ratedata{6}=E;
ratedata{7}=cp;
ratedata{8}=Hf;
ratedata{9}=enhafact;
ratedata{10}=delS0;
ratedata{11}=delH0;
ratedata{12}=rever;

fullincident=incident;
fullexident=exident;
fulltbincident=tbincident;
fullA=A;
fullm=m;
fullE=E;
fullcp=cp;
fullHf=Hf;
fullenhafact=enhafact;
fulldelS0=delS0;
fulldelH0=delH0;

fullratedata=ratedata;

