// Header file for linked list class
#include <ostream>
using namespace std;

class LinkedList{
public:
	// Constructors and Destructors
	/* Generally every class should have at least two construtors, a
	 * default constructor and a copy constructor that creates a copy
	 * of the given object*/
	LinkedList();     //default construtor
	LinkedList(const LinkedList& lst); //copy constructor
	/* Every class should have a destructor, which is responsible for
	 * cleaning  up any dynamic memory allocation performed by the class.
	 * Note the special syntax for the destructor */
	~LinkedList();    //destructor
	
	// PRE:
	// POST: A new node containing the given data is inserted at the front
	//       of the list
	// PARAM: data is the data to be stored
	void add(int data);

	// PRE:
	// POST: A new node containing the given data is inserted at the given
	//       position in the list
	// PARAM: pos specifies the (index) position to insert the new node
	//        data is the data to be stored
	void insertAt(int pos, int data);
	
	// PRE:
	// POST: The first incidence of the given data is removed from the list.
	//       Returns true if data is found (and removed), false otherwise
	// PARAM: data specifies the data to be removed from the list
	bool remove(int data );
	
	// PRE:
	// POST: Empties the list, freeing up dynaically allocated memory
	// PARAM: 
	void removeAll();

	// PRE:
	// POST: Prints the contents of the list to the stream, in order
	// PARAM:
	void printList(ostream& out);

private:
	/* A class for a node of the list.  It contains the data variable.*/
	// List node
	class Node {
	public:
		int data;   //list data
		Node *next; //pointer to next item in the list

		Node(int d) { data = d; }
		Node(const Node* node) { data = node->data; }
	};

	Node *head; //Pointer to the first node in the list
	int size; //Records the number of nodes in the list
};


