#ifndef ALLOC_ARRAY_H
#define ALLOC_ARRAY_H

#ifdef __cplusplus
extern "C" {
#endif				/* __cplusplus */

fftw_complex **alloc_carray2d(int, int, int, int, int *);
double **alloc_darray2d(int, int, int, int, int *);

/* allocate a complex 2d array with subscript range
   cm[min_x,...,max_x][min_y,...,max_y]           */
fftw_complex **alloc_carray2d(int min_x, int max_x, int min_y, int max_y,
                              int *ialloc_err)
{
  int i,nx=max_x-min_x+1,ny=max_y-min_y+1;
  fftw_complex **cm;

  *ialloc_err=0;
  cm=(fftw_complex **)malloc((size_t) nx*sizeof(fftw_complex*));
  if (cm == NULL){
    *ialloc_err=1;
    return cm;
  }
  cm -= min_x;
  cm[min_x]=(fftw_complex *)malloc((size_t) nx*ny*sizeof(fftw_complex));
  if (cm[min_x]==NULL){
    *ialloc_err=2;
    return cm;
  }
  cm[min_x]-=min_y;
  for (i=min_x+1; i <= max_x; i++) cm[i] = cm[i-1]+ny;
/* return pointer to array of pointers to rows */
  return cm;
}

void free_carray2d(fftw_complex **cm,int min_x, int max_x, int min_y, int max_y)
{
  free((void *) (cm[min_x]+min_y));
  free((void *) (cm+min_x));
}

/* allocate a double 2d array with subscript range
   dm[min_x,...,max_x][min_y,...,max_y]           */
double **alloc_darray2d(int min_x, int max_x, int min_y, int max_y,
                        int *ialloc_err)
{
  int i,nx=max_x-min_x+1,ny=max_y-min_y+1;
  double **dm;

  *ialloc_err=0;
  dm=(double **)malloc((size_t) nx*sizeof(double*));
  if (dm == NULL){
    *ialloc_err=1;
    return dm;
  }
  dm -= min_x;
  dm[min_x]=(double *)malloc((size_t) nx*ny*sizeof(double));
  if (dm[min_x]==NULL){
    *ialloc_err=2;
    return dm;
  }
  dm[min_x]-=min_y;
  for (i=min_x+1; i <= max_x; i++) dm[i] = dm[i-1]+ny;
/* return pointer to array of pointers to rows */
  return dm;
}

void free_darray2d(double **dm,int min_x, int max_x, int min_y, int max_y)
{
  free((void *) (dm[min_x]+min_y));
  free((void *) (dm+min_x));
}

#ifdef __cplusplus
}                               /* extern "C" */
#endif				/* __cplusplus */
#endif				/* ALLOC_ARRAY_H */
