#ifndef FFT2D_H
#define FFT2D_H
#include <fftw.h>
#include <mpi.h>

#ifdef __cplusplus
extern "C" {
#endif				/* __cplusplus */

typedef struct {
     int myid;
     int numprocs;
     int nx_proc;
     int ny_proc;
     MPI_Comm comm;
     MPI_Datatype block;
     MPI_Request *s_req;
     MPI_Request *r_req;
     MPI_Status *s_status;
     MPI_Status *r_status;
} fft_mpi_data_struct;

typedef fft_mpi_data_struct *fft_mpi_data;
     
typedef struct {
     fftw_plan p_fft_x;      /* plan for first dimension */
     fftw_plan p_fft_y;      /* plan for second dimension */
     fftw_complex *work;     /* work array for 1d transfroms */
     fft_mpi_data mpi_data;  /* MPI data */
} fft2d_mpi_plan_data;

typedef fft2d_mpi_plan_data *fft2d_mpi_plan;

fft2d_mpi_plan fft2d_mpi_create_plan(MPI_Comm, int, int, fftw_direction, int);
void fft2d_mpi_destroy_plan(fft2d_mpi_plan);
fft_mpi_data get_mpi_data(int, int, MPI_Comm);
void destroy_mpi_data(fft_mpi_data);
void matrix_transpose_mpi(fft_mpi_data, fftw_complex *, fftw_complex *);
void fft2d_mpi(fft2d_mpi_plan, fftw_complex *,fftw_complex *);

#ifdef __cplusplus
}                               /* extern "C" */
#endif				/* __cplusplus */
#endif				/* FFT2D_H */
