#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fftw.h>

#define pi M_PI
inline double min(double a, double b){return (a<b) ? a : b;}
inline double max(double a, double b){return (a>b) ? a : b;}

#include "randv.h"
double get_time(void);

int main(int argc,char *argv[]){
fftw_complex **hc;
fftw_complex **work;
double **h_re,**h_im,*qx,*qy;
double epscom,fft_norm,err_re,err_im,err,abs_h,starttime,cpu_time;
int ierr,iseed,l,l2,ll,lm1,nqx,nqy,i,j,k,kx,ky,it,nfft;
char yn;
fftwnd_plan fwplan,bwplan;

   if (argc < 5) {
     fprintf(stderr,"usage: %s iseed l epscom nfft\n",argv[0]);
     fprintf(stderr,"with\n"
                    "     iseed   seed for random number generator (int)\n"
                    "     l       (linear) size of the system (int)\n"
                    "     epscom  required accuracy (double)\n"
                    "     nfft    no. of FFTs to be performed (int)\n");
     exit(1);
   }
   iseed=atoi(argv[1]);
   l=atoi(argv[2]);
   l=(l/2)*2;
   seeds(iseed);
   epscom=atof(argv[3]);
   nfft=atoi(argv[4]);

     seeds(iseed);
     l2=l/2;
     lm1=l-1;
     ll=l*l;
     fft_norm=(double)ll;
     fwplan=fftw2d_create_plan(l,l,FFTW_FORWARD, 
                               FFTW_ESTIMATE | FFTW_IN_PLACE);
     bwplan=fftw2d_create_plan(l,l,FFTW_BACKWARD,
                               FFTW_ESTIMATE | FFTW_IN_PLACE);
     hc=(fftw_complex **)malloc(l*sizeof(fftw_complex));
     hc[0]=(fftw_complex *)malloc(ll*sizeof(fftw_complex));
     h_re=(double **)malloc(l*sizeof(double));
     h_re[0]=(double *)malloc(ll*sizeof(double));
     h_im=(double **)malloc(l*sizeof(double));
     h_im[0]=(double *)malloc(ll*sizeof(double));
     for (i=1;i<l;i++){
       hc[i]=hc[i-1]+l;
       h_re[i]=h_re[i-1]+l;
       h_im[i]=h_im[i-1]+l;
     }/*end for*/
     randv(&h_re[0][0],ll);
     randv(&h_im[0][0],ll);
     starttime=get_time();
     for (it=1;it<=nfft;it++){
       for (i=0;i<l;i++){
         for (j=0;j<l;j++){
           hc[i][j].re=h_re[i][j]/fft_norm;
           hc[i][j].im=h_im[i][j]/fft_norm;
         }/*end for*/
       }/*end for*/
       fftwnd_one(fwplan,&hc[0][0],NULL);
       fftwnd_one(bwplan,&hc[0][0],NULL);
     }/*end for*/
     cpu_time=get_time()-starttime;
     for (i=0;i<l;i++){
       for (j=0;j<l;j++){
         err_re=abs(h_re[i][j]-hc[i][j].re);
         err_im=abs(h_im[i][j]-hc[i][j].im);
         abs_h=sqrt(h_re[i][j]*h_re[i][j]+h_im[i][j]*h_im[i][j]);
         err=max(err_re,err_im);
         if (abs_h > epscom) err=err/abs_h;
         if (err > epscom){
           printf("i=%i, j=%i : h=(%f,%f)\n",i,j,h_re[i][j],h_im[i][j]);
           printf("               (%f,%f)\n",hc[i][j].re,hc[i][j].im);
         }/*end if*/
       }/*end for*/
     }/*end for*/
     printf("cpu-time: %f\n",cpu_time);
}
