void randv(double *rnd,int n){
/*
    Calculates an array of length n of uniformly distributed
    random numbers in the interval [0,1).
*/

#define RANDOM_MAX 2147483647
/* this is a nuisance, but can't be avoided because of the lack of a 
   standard in C for random(): on Linux (x86) random returns integers between
   0 and RAND_MAX, on IRIX it returns integers between 0 and 2147483647.
   RAND_MAX=2147483647 on Linux and RAND_MAX=32767 on IRIX. Sigh.
   Just another argument for using your own random number generator. */

int i;

   for (i=0;i<n;i++){
     rnd[i]=random()/((double)RANDOM_MAX);
        /* this is not a good random number generator, but for a random
           initial configuration it should be good enough */
   }/*end for*/
}

void seeds(int jseed){
int iseed;
#include <sys/time.h>
#include <unistd.h>
#include <limits.h>

struct timeval tv;
struct timezone tz;

  if (jseed <= 0) {
    gettimeofday(&tv,&tz);
    iseed=tv.tv_usec*(INT_MAX/1000000);
    /* tv.tv_usec contains the microseconds within the current minute.
       This number is used to initialize the RNG */
  }else{
    iseed=jseed;
  }
  srandom(iseed);
}
