function [Pts,Partition,b]=cfp_gen_infeasible(d,ColorPartition)
%
% A random generator of infeasible colorful feasibility problem.
%
% **********
% * Syntax *
% **********
% [Pts,Partition,b]=cfp_gen_infeasible(d)
% [Pts,Partition,b]=cfp_gen_infeasible(d,ColorPartition)
%
% ***************
% * Description *
% ***************
% [Pts,Partition,b]=cfp_gen_sminus(d,ColorPartition) randomly
% generates an infeasible colorful feasibility problem.
%
% ******************
% * Input Argument *
% ******************
% The input argument d is the dimension for Euclidean space.
%     The input ColorPartition a vector of length d+1 indicating the number
% of points each color should have. For example, if ColorPartition=[2 4 4],
% then the generated colorful feasibility problem should have two points
% for the first color, four points for the second, and four points for the
% last color.
%
% ********************
% * Output Arguments *
% ********************
% Pts is a matrix storing the coordinates of points. Each column of Pts
% stores the coordinate of one point. The number of rows is d, which is
% the number of dimensions of the Euclidean space. The points in each color
% of Pts must contain b in their convex hulls. All the colorful points are
% unit vectors. Scaling the colorful points does not affect whether a
% convex hull generated by them contain the origin, and b is the origin.
% Hence, all the colorful points can be scaled to unit vectors.
%   b is a column vector representing a point, and it is always generated
% as the origin. This output argument is for future potential update.
%   Partition is a row vector of length (d+1). Each element is an  integer
% no less than (d+1), specifying the number of points in a color. For
% example [3 4 3] tells that the first 3 points in Pts are in the first
% color, the following 4 points are in the second color, and so on.
%
% *************
% * Algorithm *
% *************
% Keep generating colorful feasibility problems and testing them, until an
% infeasible one is obtained. The running time can be very long.
%

%%%%%%%%%%%%%%%%%%%%%%%%% Internal Comments %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Written by Sui Huang, Advanced Optimization Lab, McMaster University,
% Hamilton, Ontario, Canada.
% 
% ************************
% * Modification History *
% ************************
% April  2007  The first version.
%

%% apply the default input arguments
if ((nargin<2)||isempty(ColorPartition))
    ColorPartition = (d+1)*ones(1,d+1);
end

%% Find an colorful feasibility problems
%  by looping until an infeasible one is found.
while (1)
    options.feasible = 0;
    [Pts,Partition,b]=cfp_gen_random(d,ColorPartition,options);
    [x,info]=cfp_solver_enumstretch(Pts,b,ColorPartition);
    if (info.feasible==0)
        break;
    end
end

return