function initT = cfp_init_random(Pts, b, ColorPartition)
%
% A random algorithm to find a colorful set of points from given colorful
% points.
%
% **********
% * Syntax *
% **********
% initT = cfp_init_random(Pts, ColorPartition , b)
%
% *******************
% * Input Arguments *
% *******************
% Pts is a matrix storing the coordinates of points. Each column of Pts
% stores the coordinate of one point. The number of rows is d, which is
% the number of dimensions of the Euclidean space. The points in each color
% of Pts must contain b in their convex hull.
%   b is a column vector representing a point in the d-Euclidean space.
%   ColorPartition is a row vector of length (d+1). Each element is an
% integer not less than (d+1), specifying the number of points in a color.
% For example [3 4 3] tells that the first 3 points in Pts are in the first
% color, the following 4 points are in the second color, and so on.
% 
% ********************
% * Output Arguments *
% ********************
% initT is a row vector of length (d+1). Its elements are column indices of
% Pts, specifying a colorful set of points (one point for each color).
%
% *************
% * Algorithm *
% *************
% Select one point from each color randomly.
%
%


%%%%%%%%%%%%%%%%%%%%%%%%% Internal Comments %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Written by Sui Huang, Advanced Optimization Lab, McMaster University,
% Hamilton, Ontario, Canada.
% 
% ************************
% * Modification History *
% ************************
% May  2005: First version.
% July 2005: Added comments.
% July 2007: Unified interface in the package for the thesis
%            "Colourful Feasibility Problem: Algorithm, Bounds and
%            Implications".
% 


% Get the number of colors.
l = length(ColorPartition);

% Allocate memory for initT.
initT = zeros(1, l);

% The variable base helps to enmulate all the point indices of each colors.
base = 0;

% Randomly select one point from each color.
for i = 1:l
    initT(i) = rand_int(1, 1, [(base+1)   (base+ColorPartition(i))]);
    base = base + ColorPartition(i);
end


return
