function r = rand_real(m, n, rg)
%
% Generate real number/numbers between rg(1) and rg(2), inclusively.
% 
% **********
% * Syntax *
% **********
% r = rand_real(m,n,rg)
%
% *******************
% * Input Arguments *
% *******************
% m and n are the height and width of the output matrix.
%   rg is a two element vector specifying the range of the random real
% number/numbers to be generated, inclusively. rg(1)<=rg(2) must be
% satisfied.
%
% ********************
% * Output Arguments *
% ********************
% r is the m by n matrix of random real numbers between rg(1) and rg(2).
%
% See also: RAND_INT


%%%%%%%%%%%%%%%%%%%%%%%%% Internal Comments %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Written by Sui Huang, Advanced Optimization Lab, McMaster University,
% Hamilton, Ontario, Canada.
% 
% ************************
% * Modification History *
% ************************
% May  2005: First version.
% July 2005: Added comments.
% 


r = rand(m,n);
r = rg(1) + (rg(2)-rg(1)) * r;

return;