function test_infeasible(ds, name_gen)

for d = ds
    
    time_summary = [];
    feas_summary = [];
    record.sdprelax = {}; 
    NumCase = 1000;
    
    fprintf(['d = ' num2str(d) '   ']);
    NumBack=0;
    
    for i = 1:NumCase
 
        for c=1:NumBack
            fprintf('\b');
        end
        NumBack = fprintf('i = %d', i);

        filname=['infeasi_cases/infeasi' num2str(d) 'd' num2str(i) '.mat'];
        if (exist(filname,'file')==2)
            load(filname);
        else
            [Pts,ColorPartition,b]=feval(name_gen,d);
            save(filname, 'Pts', 'b', 'ColorPartition');
        end

        [x,info]=cfp_solver_sdprelax(Pts,b,ColorPartition);
        record.sdprelax{i}=info;

    end

    feas_summary.sdprelax = get_feas_summary(record, 'sdprelax');
    time_summary.sdprelax = get_time_summary(record, 'sdprelax');
    
    save(['results/' name_gen num2str(d) 'd.mat'], ...
        'record', 'time_summary', 'feas_summary');
    
    fprintf('\n');

end
    
end


function summary = get_feas_summary(record, name_solver)
infoarray = getfield(record, name_solver);
summary.totalcases = length(infoarray);
summary.feasible = 0;
summary.infeasible = 0;
summary.unknown = 0;
summary.relaxfeasible = 0;
for i = 1:(summary.totalcases)
    info = infoarray{i};
    if (info.feasible==0)
        summary.infeasible = summary.infeasible + 1;
    elseif (info.feasible==-1)
        summary.unknown = summary.unknown + 1;
    elseif (info.feasible==1)
        summary.feasible = summary.feasible + 1;
    end
    if (info.relaxfeasi==1)
        summary.relaxfeasible = summary.relaxfeasible + 1;
    end 
end
end


function summary = get_time_summary(record, name_solver)
infoarray = getfield(record, name_solver);
summary.totalcases = length(infoarray);
summary.total = 0;
summary.validcases = 0;
summary.max = 0;
summary.min = Inf;
for i = 1:(summary.totalcases)
    info = infoarray{i};
    if (info.feasible == 0)
        summary.validcases = summary.validcases + 1;
        summary.total = summary.total + info.time;
        if (info.time>summary.max)
            summary.max = info.time;
        end
        if info.time<summary.min
            summary.min = info.time;
        end
    end
end
end
