package com.xd.layoutkotlin

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity

class LinearLayoutActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_linear_layout)
    }

    fun onGoBackClicked(view: View) {
        val intent = Intent(this, MainActivity::class.java)
        //intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
        intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP
        startActivity(intent)
    }

//   FLAG_ACTIVITY_CLEAR_TOP: If set, and the activity being launched is already running
//   in the current task, then instead of launching a new instance of that activity,
//   all of the other activities on top of it will be closed and this Intent will be delivered
//   to the (now on top) old activity as a new Intent.

//    FLAG_ACTIVITY_REORDER_TO_FRONT: If set in an Intent passed to Context.startActivity(),
//    this flag will cause the launched activity to be brought to the front of its task's history
//    stack if it is already running.
}