package com.xd.layoutkotlin

import android.os.Bundle
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.ListView
import androidx.appcompat.app.AppCompatActivity

class ListViewLayoutActivity : AppCompatActivity() {
    private val FACULTY = arrayOf(
        "Chris Bailey-Kellogg",
        "Devin Balkcom", "Andrew Campbell", "Michael Casey",
        "Amit Chakrabarti", "Thomas H. Cormen ",
        "Robert L. (Scot) Drysdale, III", "Hany Farid", "Lisa Fleischer",
        "Gevorg Grigoryan", "Prasad Jayanti", "David Kotz", "Lorie Loeb",
        "Fabio Pellacini", "Daniel Rockmore", "Sean Smith",
        "Lorenzo Torresani", "Peter Winkler", "Emily Whiting", "Xia Zhou"
    )
    private lateinit var myListView: ListView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_list_view_layout)

        myListView = findViewById(R.id.myListView)

        val arrayAdapter: ArrayAdapter<String> = ArrayAdapter<String>(this,
            android.R.layout.simple_list_item_1, FACULTY)
        myListView.adapter = arrayAdapter
        myListView.setOnItemClickListener(){ parent: AdapterView<*>, view: View, position: Int, id: Long ->
            println("debug: parent: $parent | view: $view | position: $position | id: $id")
        }
    }
}