package com.xd.layoutkotlin

import android.content.SharedPreferences
import android.os.Bundle
import android.view.View
import android.widget.EditText
import android.widget.RadioButton
import android.widget.RadioGroup
import androidx.appcompat.app.AppCompatActivity

class SharedPreferencesActivity : AppCompatActivity() {
    private val PREFERENCE_NAME = "my preference name"
    private val TEXT_KEY = "textview key"
    private val RADIOBUTTON_ID = "radio button id"
    private lateinit var editText: EditText
    private lateinit var radioGroup: RadioGroup

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_shared_preferences)

        editText = findViewById(R.id.editEmail)
        radioGroup = findViewById(R.id.radioGender)

        //#2
        val sharedPreferences = getSharedPreferences(PREFERENCE_NAME, MODE_PRIVATE)
        val line: String? = sharedPreferences.getString(TEXT_KEY, "")
        val radioButtonId: Int = sharedPreferences.getInt(RADIOBUTTON_ID, -1)

        editText.setText(line)
        val radioButton: RadioButton? = findViewById(radioButtonId) //XD: findViewById() could return null so radioButton has to be decleared as a nullable using "?".
        if (radioButton != null)
            radioButton.isChecked = true
    }

    fun onSaveClicked(v: View?) {
        //#1
        val line:String = editText.text.toString()
        val checkedRadioButtonID: Int = radioGroup.checkedRadioButtonId
        val sharedPreferences: SharedPreferences = getSharedPreferences(PREFERENCE_NAME, MODE_PRIVATE)
        val editor: SharedPreferences.Editor = sharedPreferences.edit()
        editor.clear()
        editor.putString(TEXT_KEY, line)
        editor.putInt(RADIOBUTTON_ID, checkedRadioButtonID)
        editor.commit()
        finish()
    }

    fun onCancelClicked(v: View?) {
        finish()
    }
}